'use strict';

const Controller = require('egg').Controller;
const MAP_POINT_FUNCTION = {
    used_house: 'getUsedHouseMapPoint',
    new_house: 'getNewHouseMapPoint',
}

class ToolController extends Controller {

    //获取地图上的点位
    async getMapPoint() {
        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            house_style: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
            level: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const house_style = input_parmas.house_style;
        const area_code = input_parmas.area_code;
        const level = input_parmas.level;

        let ret = [];
        if (house_style === 'used_house') {
            ret = await ctx.service.house.tool.getUsedHouseMapPoint(area_code, level);
        } else if(house_style === 'new_house'){
            ret = await ctx.service.house.tool.getNewHouseMapPoint(area_code, level);
        }

        ctx.success({ results: ret });
    }

    //生成购房计划
    async generateBuyHousePlan() {

        const { ctx } = this;
        const input_parmas = ctx.request.body;
        const rule = {
            city_code: { type: 'string', required: true },
            down_payment: { type: 'string', required: true },
            invest_payment: { type: 'string', required: true }
        }
        ctx.validate(rule, input_parmas);

        const target_house = await ctx.blockModel.HousePriceMap.one({ where: { id: input_parmas.city_code } });
        let target_price = 0;
        if (target_house && target_house.price) {
            target_price = target_house.price;
        }
        const filter = {
            price: { min: target_price - 300000, max: target_price + 300000 },
        }
        const recommend_houses = await ctx.service.house.rentalHouse.getRentalHousesByFilter(filter);//推荐房源
        // const recommend_houses = [];//推荐房源

        const house_plan = await ctx.service.house.tool.generateHousePlan(input_parmas);//计算购房能力 生成购房计划
        const ret = {
            house_plan,
            recommend_houses,
        }

        ctx.success({ results: ret });
    }
}

module.exports = ToolController;
