
'use strict';

const Service = require('egg').Service;

class ToolService extends Service {

    async getNewHouseMapPoint(area_code, level) {

        const { ctx } = this;
        let map_points = [];
        if(level == 1){
            map_points = await ctx.blockModel.HouseNewHousePriceMap.all({ where: { pid: area_code } });
        } else {
            map_points = await ctx.blockModel.HouseNewHousePriceMap2.all({ where: { pid: area_code } });
        }
        
        if (!map_points || map_points.length === 0) {
            return [];
        }

        const ret = [];
        for (let i in map_points) {
            const item = map_points[i];
            ret.push({
                id: item.id,
                name: item.name,
                longitude: item.longitude,
                latitude: item.latitude,
                price: item.price,
                unit: item.unit || '元/平',
            });
        }

        return ret;
    }

    async getUsedHouseMapPoint(area_code, level) {

        const { ctx } = this;
        let map_points = [];
        if (level == 1) {
            map_points = await ctx.blockModel.HousePriceMap.all({ where: { pid: area_code } });
        } else if (level == 2) {
            map_points = await ctx.blockModel.HousePriceMap2.all({ where: { pid: area_code } });
        } else {
            map_points = await ctx.blockModel.HousePriceMap3.all({ where: { pid: area_code } });
        }

        if (!map_points || map_points.length === 0) {
            return [];
        }
        const ret = [];
        for (let i in map_points) {
            const item = map_points[i];
            ret.push({
                id: item.id,
                name: item.name,
                longitude: item.longitude,
                latitude: item.latitude,
                price: item.price,
                unit: item.unit || '元/平',
            });
        }

        return ret;
    }

    async generateHousePlan(input) {

        const { ctx } = this;
        const down_payment = input.down_payment || 0;//首付金额
        const invest_payment = input.invest_payment || 0;//投资金额
        const balance = down_payment - invest_payment;
        let notice = '';
        let status = 0;
        let plan = [];
        if (balance < 0) {
            status = 2;//完全有能力买到房
            notice = '您的资金已满足本项目首付条件，还有更多项目在您预算范围内。一键预约，轻松看房！';
            return { status, notice, plan };
        }
        const rate = balance / invest_payment;
        if (rate >= 0.5) {
            status = 0;//完全没有希望能买到房
            notice = '非常遗憾，您的首付预算距离购买该项目尚有较大差距，您可以选择以下方案：';
        } else {
            status = 1;//j加把劲还是有希望买到房
            notice = '恭喜您！依据以上计划，您即将完成XXX项目首付款准备。您现阶段首付预算可以购买以下项目房源：';
        }

        return { status, notice, plan };
    }
}

module.exports = ToolService;
