
'use strict';

const Service = require('egg').Service;

const AGE_CATS = [
    { id: -2, name: '全部', value: 0 },
    { id: -3, name: '3岁以下', value: 3 },
    { id: -4, name: '4岁', value: 4 },
    { id: -5, name: '5岁', value: 5 },
    { id: -6, name: '6岁', value: 6 },
    { id: -7, name: '7岁', value: 7 },
    { id: -8, name: '8岁', value: 8 },
    { id: -9, name: '9岁', value: 9 },
    { id: -10, name: '10岁', value: 10 },
    { id: -11, name: '11岁', value: 11 },
    { id: -12, name: '12岁', value: 12 },
    { id: -13, name: '12岁以上', value: 13 },
];

const INSTITUTION_TYPE = [
    { id: -14, name: '全部', value: '' },
    { id: -15, name: '品牌', value: '品牌' },
];

class OptionService extends Service {


    /**
     * 我的信用首页
     */
    async getOptions() {

        const { ctx } = this;
        const cats = await ctx.classModel.CourseCat.all({ where: { status: 1, is_deleted: 0 } });
        const tree_cats = this.getTrees(cats, 0);

        const options = {
            cats: tree_cats,
            ages: AGE_CATS,
            institutions: INSTITUTION_TYPE,
        }
        return options;
    }

    getTrees(data, rootId) {
        const ret = [];
        for (let i = 0; i < data.length; i++) {
            const node = data[i];
            if (node.parent_id == rootId) {
                const newNode = {};
                if (node.parent_id !== 0) ret.push({ id: 0, name: '全部', value: '' });
                newNode.id = node.id;
                newNode.name = node.name;
                newNode.tips = node.tips;
                newNode.image = node.image;
                newNode.color = node.color;
                newNode.level = node.level;
                newNode.value = node.id;
                newNode._child = this.getTrees(data, node.id);
                ret.push(newNode);
            }
        }
        return ret;
    }

}

module.exports = OptionService;
