'use strict';

const Controller = require('egg').Controller;

class RentalHouseController extends Controller {

  //租房首页信息
  async home() {

    const { ctx } = this;
    //banners
    const app_user_id = ctx.appUserId;
    const user_id = ctx.userId;
    const token = ctx.token;
    const device_id = ctx.device_id;
    const device_login_id = ctx.device_login_id;
    const headers = {
      // app_user_id: app_user_id,
      // device_id: device_id || '0ef939ea-9bb7-4d21-b98a-53bdad418ad9',
      // device_login_id: device_login_id,
      // token: token,
      // uid: user_id,
      cookie: `app_user_id=${app_user_id}; device_id=${device_id}; device_login_id=${device_login_id}; token=${token}; user_id=${user_id};`
    }
    // house_h5_rental_home_banners
    const banners_result = await ctx.helper.send_request(this.config.NODE_BASE_URL + '/51app/api/block/all', { alias: '51fangc_rental_home_banners' }, { method: 'GET', dataType: 'json', headers: headers });
    let banners = [];
    if (banners_result.status === 200) {
      banners = banners_result.data.results;
    }
    const developers = await ctx.service.house.option.getDevelopers();//品牌信息

    ctx.success({ banners, developers });
  }

  //租房列表
  async getRentalHouses() {

    const { ctx } = this;
    const input_params = ctx.request.body;

    const rule = {
      brand: { type: 'string', required: false },//品牌
      area_code: { type: 'object', required: false },//区域
      price: { type: 'object', required: false },//价格
      house_type: { type: 'string', required: false },//房型
      name: { type: 'string', required: false }//楼盘名称
    };
    ctx.validate(rule, input_params);
    const ret = await ctx.service.house.rentalHouse.getRentalHousesByFilter(input_params);
    ctx.success({input_params, results: ret.results, count: ret.count });
  }

  //租房详情
  async getRentalHouse() {
    const { ctx } = this;
    const input_params = ctx.params;
    if (!input_params.rental_house_id) {
      ctx.failed('rental_house_id error');
    }
    const rental_house_id = input_params.rental_house_id;
    const ret = await ctx.service.house.rentalHouse.getRentalHouse(rental_house_id);
    ctx.success(ret);
  }

}

module.exports = RentalHouseController;
