'use strict';

module.exports = () => {
  return async function(ctx, next) {
    const bearerToken = ctx.request.header.authorization;
    ctx.logger.info('course_headers: ' + JSON.stringify(ctx.request.header));
    if (!bearerToken) {
      ctx.throw(401, 'error auth');
    }
    const token = bearerToken.replace('Bearer ', '');
    const decode_res = await ctx.service.jwt.decode_token(token);
    ctx.logger.info('course_back_decode_res: ' + JSON.stringify(decode_res));
    if (ctx.isEmpty(decode_res)) {
      ctx.throw(401, 'jwt校验失败');
    }
    const token_black = await ctx.app.memcache.get('course_back_auth_token_' + decode_res.data.user_uuid);
    if (token_black !== token) {
      ctx.throw(401, 'token不一致');
    }
    ctx.setUserUuid(decode_res.data.user_uuid);
    await next();
  };
};
