'use strict';

module.exports = appInfo => {
  const config = exports = {};
  config.debug = true;

  // use for cookie sign key, should change to your own and keep security
  config.keys = appInfo.name + '_1554705194320_9697';


  config.projectRootPath = '/51business/api';

  config.logger = {
    dir: '/jianbing/logs/51business',
  };
  // add your config here
  config.middleware = [ 'errorHandler', 'deviceLogin', 'deviceInit', 'responseSet' ];

  // 是否启用csrf安全
  config.security = {
    csrf: {
      enable: false,
    },
    domainWhiteList: [],
  };

  config.jwt = {
    secret: '51business',
    exp: Math.floor(Date.now() / 1000) + 60 * 60 * 24 * 30,
    enable: false, // default is false
    ignore: [],
  };

  config.sequelize = {

    datasources: [
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'blockModel',
        baseDir: 'model/block',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_BLOCK_HOST,
        database: process.env.MYSQL_BLOCK_DB_NAME,
        username: process.env.MYSQL_BLOCK_USER,
        password: process.env.MYSQL_BLOCK_PWD,
        port: 3306,
      },
      {
        // 公积金数据库
        timezone: '+08:00',
        delegate: 'gjjModel',
        baseDir: 'model/gjj',
        dialect: 'mysql',
        host: process.env.MYSQL_GJJ_HOST,
        database: process.env.MYSQL_GJJ_DB_NAME,
        username: process.env.MYSQL_GJJ_USER,
        password: process.env.MYSQL_GJJ_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'realestateModel',
        baseDir: 'model/realestate',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_REALESTATE_HOST,
        database: process.env.MYSQL_REALESTATE_DB_NAME,
        username: process.env.MYSQL_REALESTATE_USER,
        password: process.env.MYSQL_REALESTATE_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'huodongModel',
        baseDir: 'model/huodong',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_HUODONG_HOST,
        database: process.env.MYSQL_HUODONG_DB_NAME,
        username: process.env.MYSQL_HUODONG_USER,
        password: process.env.MYSQL_HUODONG_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'prometheusModel',
        baseDir: 'model/prometheus',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_PROMETHEUS_HOST,
        database: process.env.MYSQL_PROMETHEUS_DB_NAME,
        username: process.env.MYSQL_PROMETHEUS_USER,
        password: process.env.MYSQL_PROMETHEUS_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'classModel',
        baseDir: 'model/class',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_CLASS_HOST,
        database: process.env.MYSQL_CLASS_DB_NAME,
        username: process.env.MYSQL_CLASS_USER,
        password: process.env.MYSQL_CLASS_PWD,
        port: 3306,
      },
    ],

  };

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };

  exports.oss = {// sdfsdfsd
    client: {
      accessKeyId: 'LTAIxEMB8ucstyi8',
      accessKeySecret: 'sCVJSCPyfaSIlS5R8fH4Xl77yHKR3z',
      bucket: '51shequ',
      endpoint: 'oss-cn-hangzhou.aliyuncs.com',
      timeout: '60s',
    },
  };

  exports.bodyParser = {
    jsonLimit: '1mb',
    formLimit: '1mb',
  };

  config.CDN_BASE_URL = 'https://r.51gjj.com/image/';
  config.NODE_URL = process.env.NODE_URL;
  config.NODE_BASE_URL = process.env.NODE_BASE_URL;
  config.NODEV2_URL = process.env.NODEV2_URL;
  config.PHP_URL = process.env.PHP_URL;

  config.HOUSE_SERVICE_API = process.env.HOUSE_SERVICE_API; // 房产

  config.USER_CENTER_API_URI = process.env.USER_CENTER_API_URI;

  config.BLACKLIST_APPLY_APPKEY = process.env.BLACKLIST_APPLY_APPKEY;// 黑名单对接
  config.BLACKLIST_APPLY_APPSECRET = process.env.BLACKLIST_APPLY_APPSECRET;
  config.BLACKLIST_APPLY_URL = process.env.BLACKLIST_APPLY_URL;

  // 微信支付相关内容
  config.MCH_APPID = process.env.MCH_APPID;// 商户关联的APPID
  config.MCH_ID = process.env.MCH_ID;// 商户id
  config.MCH_KEY = process.env.MCH_KEY;// 商户秘钥

  config.OUT_P_NODE_URL = process.env.OUT_P_NODE_URL;
  config.PULIC_BASE_URL = process.env.PULIC_BASE_URL;

  // 数盒魔方
  config.SHUHEMOFANG_APP_KEY = process.env.SHUHEMOFANG_APP_KEY;
  config.SHUHEMOFANG_APP_SECRET = process.env.SHUHEMOFANG_APP_SECRET;
  config.SHUHEMOFANG_URL = process.env.SHUHEMOFANG_URL;

  // 腾讯位置服务
  config.TX_LBS_KEY = process.env.TX_LBS_KEY;
  config.TX_LBS_DISTANCE_URL = process.env.TX_LBS_DISTANCE_URL; // 距离计算（一对多）
  config.TX_LBS_ADDRESS_URL = process.env.TX_LBS_ADDRESS_URL; // 地址解析；逆地址解析
  config.TX_LBS_URL = process.env.TX_LBS_URL; // 腾讯MAP API

  // 我的信用-通化检测
  config.YYS_APP_KEY = process.env.YYS_APP_KEY;
  config.YYS_APPLY_APPSECRET = process.env.YYS_APPLY_APPSECRET;


  // 运营商报告
  config.YYS_REPORT_KEY = process.env.YYS_REPORT_KEY;
  config.YYS_REPORT_APPSECRET = process.env.YYS_REPORT_APPSECRET;
  config.YYS_REPORT_URL = process.env.YYS_REPORT_URL;

  // 度小满金融查询
  config.DXM_APP_ID = process.env.DXM_APP_ID;
  config.DXM_SECRET = process.env.DXM_SECRET;
  config.DXM_URL = process.env.DXM_URL;
  config.DXM_FR = process.env.DXM_FR;

  config.CFG_ENV = process.env.CFG_ENV;
  config.CASSANDRA_API = process.env.CASSANDRA_API;

  // 趣选课微信配置
  config.COURSE_WX_APPID = process.env.COURSE_WX_APPID;
  config.COURSE_WX_SECRET = process.env.COURSE_WX_SECRET;

  return config;
};
