'use strict';

const Controller = require('egg').Controller;
const uuidv4 = require('uuid/v4');
class UserController extends Controller {
  // 手机登录
  async loginByPhone() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params.phone) || isNaN(params.phone) || params.phone.length !== 11) {
      ctx.failed('手机号错误');
    }
    if (ctx.isEmpty(params.code)) {
      ctx.failed('验证码错误');
    }

    const ret = await service.course.v5.user.loginByPhone(params);
    ctx.success(ret);
  }

  // 发送验证码
  async sendVerificationCode() {
    const { ctx, service } = this;
    const queryParams = ctx.request.body;

    if (ctx.isEmpty(queryParams.phone) || !ctx.helper.isPhoneNumber(queryParams.phone)) {
      ctx.failed('手机号错误');
    }

    const ret = await service.course.v5.user.sendVerificationCode(queryParams);
    ctx.success(ret);
  }

  // 微信登录
  async loginByWX() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params.code)) {
      ctx.failed('code is empty');
    }

    const ret = await service.course.v5.user.loginByWX(params);
    ctx.success(ret);
  }

  // 授权后注册用户信息
  async registerUserInfo() {
    const { ctx, service } = this;
    const input_params = ctx.request.body;
    const { avatar, nickname, province, country, sex, city, userUuid } = input_params;
    const encryptedData = input_params.encryptedData || '';
    const iv = input_params.iv || '';
    const params = { avatar, nickname, province, country, sex, city, encryptedData, iv, userUuid };

    const ret = await service.course.v5.user.registerUserInfo(params);
    ctx.success(ret);
  }

  // 获取用户信息
  async getUserInfo() {
    const { ctx, service } = this;

    const ret = await service.course.v5.user.getUserInfo();

    ctx.success(ret);
  }


  // 上传用户宝宝信息
  async addUserBaby() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    const ret = await service.course.v5.user.addUserBaby(params);
    ctx.success(ret);
  }


  // 新增用户收货地址
  async addUserAddress() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    const ret = await service.course.v5.user.addUserAddress(params);
    ctx.success(ret);
  }


  // 获取用户收货地址
  async getUserAddress() {
    const { ctx, service } = this;

    const ret = await service.course.v5.user.getUserAddress();
    ctx.success(ret);
  }


  // 购买课程
  async buyClass() {
    const { ctx, service } = this;
    const params = ctx.params;
    const queryParams = ctx.request.body || {};

    if (ctx.isEmpty(params) || ctx.isEmpty(params.class_id)) {
      ctx.failed('class_id is failed');
    }

    queryParams.id = params.class_id;

    const ret = await service.course.v5.user.buyClass(queryParams);
    ctx.success(ret);
  }


  // 用户订单列表
  async getUserOrderList() {
    const { ctx, service } = this;

    const ret = await service.course.v5.user.getUserOrderList();
    ctx.success(ret);
  }


  // 兑换课程
  async redeemClass() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.code)) {
      ctx.failed('code is failed');
    }

    const ret = await service.course.v5.user.redeemClass(params);
    ctx.success(ret);
  }


  // app登录
  async loginByApp() {
    const { ctx, service } = this;

    const ret = await service.course.v5.user.loginByApp();
    ctx.success(ret);
  }


  // 获取用户的礼品列表
  async getUserActImageList() {
    const { ctx, service } = this;

    const ret = await service.course.v5.user.getUserActImageList();
    ctx.success(ret);
  }


  // 更新用户的礼品列表
  async addUserActImages() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.id)) {
      ctx.failed('id is failed');
    }

    const ret = await service.course.v5.user.addUserActImages(params);
    ctx.success(ret);
  }


  // 获取用户购买的兑换码
  async getUserClassRedeemCode() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.class_id)) {
      ctx.failed('class_id is empty');
    }

    const ret = await service.course.v5.user.getUserClassRedeemCode(queryParams);
    ctx.success(ret);
  }


  // 更新用户订单
  async updateUserOrder() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.order_no)) {
      ctx.failed('order_no is failed');
    }

    if (ctx.isEmpty(params) || ctx.isEmpty(params.id)) {
      ctx.failed('id is failed');
    }

    const ret = await service.course.v5.user.updateUserOrder(params);
    ctx.success(ret);
  }
}

module.exports = UserController;
