
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class OrderService extends Service {

    //历史订单
    async getHistoryOrders(order_type) {

        const { ctx } = this;
        const type_obj = {
            'blacklist': 1,
            'callrisk': 2,
        }

        const type = type_obj[order_type];

        const order_records = await ctx.prometheusModel.CreditOrder.all({ where: { type } });
        const worth_h = [];
        const worth_l = [];
        const worth_time = type === 1 ? 15 : 30;
        const now_time = moment().format('X');
        for (let i in order_records) {

            const order = order_records[i];
            const expire_time = moment(state_time).format('X') + worth_time * 86400;

            const apply = { phone: '15968762898', report_no: '51gjj201909050100001' };

            const item = {
                order_no: order.order_no,
                report_no: apply.report_no,
                type: order_type,
                created_time,
                phone: apply.phone.replace(apply.phone.substring(3, 7), "****"),
                state: order.state,
                state_text: order.state === '已支付' ? '' : order.state,
            };
            if (order.pay_status === 1 && order.state === '已支付' && expire_time > now_time) {
                worth_h.push(item);
            } else {
                worth_l.push(item);
            }
        }

        return { worth_h, worth_l }

    }

    /**
     * 
     * @param {*} type 报告类型(黑名单1通话2)
     * @param {*} reportId 订单编号
     */
    async getReportValid(type, reportId) {
        const { ctx } = this;
        let valid = 0;
        let orderFilter = {
            where: {
                report_id: reportId,
                valid: 1
            }
        };
        let orderInfo = await ctx.prometheusModel.CreditOrder.findOne(orderFilter);
        if (orderInfo != null) {
            let timeLine = (type === 1) ? 15 : 30;
            if (orderInfo.state === '已支付' && moment(orderInfo.state_time).add(timeLine, 'days').format('YYYY-MM-DD HH:ii:ss') > moment().format('YYYY-MM-DD HH:ii:ss')) {
                valid = 1;
            }
        }
        return valid;
    }


}

module.exports = OrderService;
