'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, TEXT, DECIMAL } = app.Sequelize;
    const AbroadHouse = app.realestateModel.define('abroad_house', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        name: {
            type: STRING,
            allowNull: true
        },
        images: {
            type: TEXT,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        total_price: {
            type: DECIMAL,
            allowNull: true
        },
        url: {
            type: STRING,
            allowNull: true
        },
        order: {
            type: INTEGER,
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        status: {
            type: STRING,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
        timestamps: false,
        tableName: 'abroad_house',
    });


    return AbroadHouse;

};
