'use strict';

const Controller = require('egg').Controller;

class BackController extends Controller {
  // 登录
  async login() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.account)) {
      ctx.failed('account is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.password)) {
      ctx.failed('password is empty');
    }

    const ret = await service.course.back.login(params);
    ctx.success(ret);
  }


  // 获取菜单
  async getMenuList() {
    const { ctx, service } = this;

    const ret = await service.course.back.getMenuList();
    ctx.success(ret);
  }


  // 获取订单列表
  async getOrderList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.back.getOrderList(queryParams);
    ctx.success(ret);
  }


  // 获取兑换码列表
  async getRedeemCodeList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.back.getRedeemCodeList(queryParams);
    ctx.success(ret);
  }

  // 生成兑换码
  async addRedeemCode() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.channel)) {
      ctx.failed('channel is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.class_id)) {
      ctx.failed('class_id is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.num)) {
      ctx.failed('num is empty');
    }

    const ret = await service.course.back.addRedeemCode(params);
    ctx.success(ret);
  }


  // 获取课程列表
  async getClassList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.back.getClassList(queryParams);
    ctx.success(ret);
  }


  // 导出订单
  async exportOrder() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    await service.course.back.exportOrder(queryParams);
    // ctx.success(ret);
  }


  // 导出兑换码
  async exportRedeemCode() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    await service.course.back.exportRedeemCode(queryParams);
  }
}

module.exports = BackController;
