'use strict';

const Controller = require('egg').Controller;

class Export20190425 extends Controller {

    //新房 包含了对应的新房户型和小区信息
    async moveNewHouse() {
        const { ctx } = this;
        let data = {
            pageIndex: 1,
            pageSize: 999,
            orderConditions: [{
                key: 'id',
                orderSequence: 'asc',
            }]
        }
        const retList = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/newhouse/list', data, { method: 'POST' });
        if (retList.status !== 200) {
            ctx.failed('error');
        }
        let newHouseList = retList.data;
        let ret = {
            newHouse: [],
            newHouseType: [],
        };
        if (newHouseList.rowCount > 0) {
            let list = newHouseList.results;
            for (let i in list) {
                let newHouseData = {
                    name: list[i].name,
                    residential_id: list[i].residentialId,
                    // developer_id: list[i].xxx,
                    province: list[i].province,
                    city: list[i].city,
                    area: list[i].county,
                    address: list[i].address,
                    sale_province: list[i].province,
                    sale_city: list[i].city,
                    sale_area: list[i].county,
                    sale_address: list[i].saleAddress,
                    tags: list[i].tags,
                    sale_type: list[i].saleType,
                    house_type: list[i].houseType,
                    reference_avg_price: list[i].referenceAvgPrice,
                    reference_total_price: list[i].referenceTotalPrice,
                    image: list[i].image,
                    corner: list[i].cornerMarker,
                    discount: list[i].discount,
                    favourable_info: list[i].favourableInfo,
                    decoration_type: list[i].decorationType,
                    description: list[i].description,
                    open_date: list[i].openDate,
                    due_date: list[i].dueDate,
                    land_area: list[i].landArea,
                    house_area: list[i].houseArea,
                    area_ratio: list[i].areaRatio,
                    green_ratio: list[i].greenRatio,
                    plan_rooms: list[i].planRooms,
                    plan_parks: list[i].planParks,
                    plan_near_by: list[i].planNearBy,
                    pre_sale_permit: list[i].preSalePermit,
                    pre_sale_permit_date: list[i].preSalePermitDate,
                    building_numbers: list[i].buildingNumbers,
                    selling_qualification: list[i].xxx,
                    remark: list[i].remark,
                    // is_reality: list[i].xxx,
                    order_id: list[i].orderNum,
                    status: Number(list[i].state) === 0 ? 'offline' : 'online',
                    valid: 1,
                    created_at: list[i].createdAt,
                    updated_at: list[i].updatedAt || null,
                    // deleted_at: list[i].xxx,
                    option_city_code: list[i].residential.city,
                    option_district_code: list[i].residential.county,
                    option_bizicircle_code: list[i].residential.region,
                    residential_property_right_years: list[i].residential.propertyRightYears,
                    residential_property_fee: list[i].residential.propertyFee,
                    residential_property_company: list[i].residential.propertyCompany,
                    residential_heat_supply_type: list[i].residential.heatSupplyType,
                    residential_water_suppler_type: list[i].residential.waterSupplyType,
                    residential_power_suppler_type: list[i].residential.powerSupplyType,
                    residential_land_area: list[i].residential.landArea,
                    residential_house_area: list[i].residential.houseArea,
                    residential_area_ratio: list[i].residential.areaRatio,
                    residential_green_ratio: list[i].residential.greenRatio,
                    residential_arch_type: list[i].residential.archType,
                    residential_nearby: list[i].residential.nearBy,
                }
                //房源信息和小区信息
                let id = await ctx.realestateModel.NewHouse.add(newHouseData);
                ret.newHouse.push(id);
                //户型
                if (list.newHouseType.length > 0) {
                    for (let j in list.newHouseType) {
                        let newHouseDataTypeData = {
                            new_house_id: list.newHouseType[j].newHouseId,
                            type: list.newHouseType[j].type,
                            image: list.newHouseType[j].image,
                            tags: list.newHouseType[j].tags,
                            apartment: list.newHouseType[j].apartment,
                            sale_type: list.newHouseType[j].saleType,
                            area: list.newHouseType[j].area,
                            orientation: list.newHouseType[j].orientation,
                            num: list.newHouseType[j].num,
                            price: list.newHouseType[j].price,
                            discount: list.newHouseType[j].discount,
                            status: Number(list.newHouseType[j].state) === 0 ? 'offline' : 'online',
                            remark: list.newHouseType[j].remark,
                            valid: 1,
                            created_at: list.newHouseType[j].created_at,
                            updated_at: list.newHouseType[j].updated_at || null,
                            // deleted_at: list.newHouseType[j].xxx,
                        }
                        let typeId = await ctx.realestateModel.NewHouseType.add(newHouseDataTypeData);
                        ret.newHouseType.push(typeId);
                    }
                }
            }
        }
        ctx.success(ret);
    }


    //收藏
    async moveCollection() {
        const { ctx } = this;
        let data = {
            pageIndex: 1,
            pageSize: 99999,
            orderConditions: [{
                key: 'id',
                orderSequence: 'asc',
            }]
        }
        const retList = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/collection/list', data, { method: 'POST' });
        if (retList.status !== 200) {
            ctx.failed('error');
        }
        let res = retList.data;
        let ret = {
            id: [],
        };
        if (res.rowCount > 0) {
            let list = res.results;
            for (let i in list) {
                let addData = {
                    user_id: list[i].userId,
                    app_user_id: list[i].appUserId,
                    house_style: list[i].houseStyle,
                    connect_id: list[i].connectId,
                    state: list[i].state,
                    remark: list[i].remark,
                    created_at: list[i].createdAt,
                    updated_at: list[i].updatedAt || null,
                    deleted_at: list[i].xxx,
                }
                let id = await ctx.realestateModel.Collection.add(addData);
                ret.id.push(id);
            }
        }
        ret.count = ret.id.length;
        ctx.success(ret);
    }

    //预约
    async moveOrder() {
        const { ctx } = this;
        let data = {
            pageIndex: 1,
            pageSize: 99999,
            orderConditions: [{
                key: 'id',
                orderSequence: 'asc',
            }]
        }
        const retList = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/order/list', data, { method: 'POST' });
        if (retList.status !== 200) {
            ctx.failed('error');
        }
        let res = retList.data;
        let ret = {
            id: [],
        };
        if (res.rowCount > 0) {
            let list = res.results;
            for (let i in list) {
                let addData = {
                    user_id: list[i].userId,
                    app_user_id: list[i].appUserId,
                    house_style: list[i].houseStyle,
                    connect_id: list[i].connectId,
                    name: list[i].name,
                    phone: list[i].phone,
                    order_at: list[i].orderAt,
                    state: list[i].state,
                    remark: list[i].remark,
                    created_at: list[i].createdAt,
                    updated_at: list[i].updatedAt || null,
                    // deleted_at:list[i].xxx,
                }
                let id = await ctx.realestateModel.Order.add(addData);
                ret.id.push(id);
            }
        }
        ret.count = ret.id.length;
        ctx.success(ret);
    }

    //搜索历史
    async moveHistory() {
        const { ctx } = this;
        let data = {
            pageIndex: 1,
            pageSize: 99999,
            orderConditions: [{
                key: 'id',
                orderSequence: 'asc',
            }]
        }
        const retList = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/list', data, { method: 'POST' });
        if (retList.status !== 200) {
            ctx.failed('error');
        }
        let res = retList.data;
        let ret = {
            org_count: res.rowCount,
            id: [],
        };
        if (res.rowCount > 0) {
            let list = res.results;
            for (let i in list) {
                let addData = {
                    user_id: list[i].userId,
                    app_user_id: list[i].appUserId,
                    key_word: list[i].keyWord,
                    house_style: list[i].houseStyle,
                    state: list[i].state,
                    created_at: list[i].createdAt,
                    // updated_at: list[i].xxx,
                    // deleted_at: list[i].xxx,
                }
                let id = await ctx.realestateModel.SearchHistory.add(addData);
                ret.id.push(id);
            }
        }
        ret.count = ret.id.length;
        ctx.success(ret);
    }

    //足迹
    async moveFoot() {
        const { ctx } = this;
        let data = {
            pageIndex: 1,
            pageSize: 99999,
            orderConditions: [{
                key: 'id',
                orderSequence: 'asc',
            }]
        }
        const retList = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/list', data, { method: 'POST' });
        if (retList.status !== 200) {
            ctx.failed('error');
        }
        let res = retList.data;
        let ret = {
            org_count: res.rowCount,
            id: [],
        };
        if (res.rowCount > 0) {
            let taskList = [];
            let list = res.results;
            for (let i in list) {
                let addData = {
                    user_id: list[i].userId,
                    // app_type_id:list[i].xxx,
                    app_user_id: list[i].appUserId,
                    house_style: list[i].xxx,
                    connect_id: list[i].connectId,
                    state: list[i].state,
                    remark: list[i].remark,
                    created_at: list[i].createdAt,
                    updated_at: list[i].updatedAt || null,
                    // deleted_at: list[i].xxx,
                }
                taskList[i] = ctx.realestateModel.FootPrint.add(addData);
            }
            const retList = await Promise.all(taskList).then(result => {
                return result;
            }).catch(error => {
                ctx.failed(error);
            });
            ret.id = retList;
        }
        ret.count = ret.id.length;
        ctx.success(ret);
    }

}

module.exports = Export20190425;
