'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, TEXT } = app.Sequelize;
    const CreditApply = app.prometheusModel.define('credit_apply', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        type: INTEGER,
        user_id: STRING,
        app_user_id: STRING,
        app_id: STRING,
        app_type_id: STRING,
        name: STRING,
        phone: STRING,
        id_card: STRING,
        service_code: STRING,
        timestamp: STRING,
        appkey: STRING,
        sign: STRING,
        r_code: STRING,
        r_msg: STRING,
        r_order_id: STRING,
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
        timestamps: false,
        tableName: 'credit_apply',
    });

    return CreditApply;

};
