'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const HousePriceMap = app.blockModel.define('house_price_map', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    pid: INTEGER,
    name: STRING,
    spell: STRING,
    longitude: STRING,
    latitude: STRING,
    price: INTEGER,
    is_top: INTEGER,
  }, {
    timestamps: false,
    tableName: 'house_price_map',
    freezeTableName: true,
  });

  HousePriceMap.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HousePriceMap.findOne({
      attributes: attributes,
      where : where,
    });
  }


  HousePriceMap.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HousePriceMap.findAll({
      attributes: attributes,
      where : where,
    });
  }

  HousePriceMap.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };

    const { count, rows } =  await HousePriceMap.findAndCountAll(condition);
    return { page, count, rows };
  }

  HousePriceMap.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HousePriceMap.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  HousePriceMap.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    HousePriceMap.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return HousePriceMap;

};
