'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;
  const Banner = app.huodongModel.define('cfg_banner_images', {
    sid: { type: INTEGER, primaryKey: true, autoIncrement: true },
    banner_id: INTEGER,
    link: STRING,
    image: STRING,
    sort_order: INTEGER,
    title: STRING,
    description: STRING,
    filed1: STRING,
    filed2: STRING,
    filed3: STRING,
    start_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('start_time');
        return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
      },
    },
    end_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('end_time');
        return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
      },
    },
  }, {
    timestamps: false,
    tableName: 'cfg_banner_images',
  });

  return Banner;
};
