'use strict';
const cheerio = require('cheerio');
const Controller = require('egg').Controller;
const USER_AGENT = [
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 UBrowser/4.0.3214.0 Safari/537.36',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Maxthon/4.4.3.4000 Chrome/30.0.1599.101 Safari/537.36',
    'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.84 Safari/535.11 SE 2.X MetaSr 1.0',
    'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; QQBrowser/7.0.3698.400)',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.71 Safari/537.1 LBBROWSER',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.11 (KHTML, like Gecko) Chrome/20.0.1132.11 TaoBrowser/2.0 Safari/536.11',
    'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.101 Safari/537.36',
    'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.16 (KHTML, like Gecko) Chrome/10.0.648.133 Safari/534.16',
    'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2',
    'Mozilla/5.0 (X11; U; Linux x86_64; zh-CN; rv:1.9.2.10) Gecko/20100922 Ubuntu/10.10 (maverick) Firefox/3.6.10',
    'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0',
    'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.50',
    'Mozilla/5.0 (Windows NT 5.1; U; en; rv:1.8.1) Gecko/20061208 Firefox/2.0.0 Opera 9.50',
    'Opera/8.0 (Windows NT 5.1; U; en)',
    'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36 OPR/26.0.1656.60',
    'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; SV1; QQDownload 732; .NET4.0C; .NET4.0E; SE 2.X MetaSr 1.0)',
    'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; QQDownload 732; .NET4.0C; .NET4.0E)',
    'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; QQDownload 732; .NET4.0C; .NET4.0E; LBBROWSER)',
    "Mozilla/5.0 (Linux; U; Android 2.3.6; en-us; Nexus S Build/GRK39F) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1",
    "Avant Browser/1.2.789rel1 (http://www.avantbrowser.com)",
    "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/532.5 (KHTML, like Gecko) Chrome/4.0.249.0 Safari/532.5",
    "Mozilla/5.0 (Windows; U; Windows NT 5.2; en-US) AppleWebKit/532.9 (KHTML, like Gecko) Chrome/5.0.310.0 Safari/532.9",
    "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/534.7 (KHTML, like Gecko) Chrome/7.0.514.0 Safari/534.7",
    "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/534.14 (KHTML, like Gecko) Chrome/9.0.601.0 Safari/534.14",
    "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.14 (KHTML, like Gecko) Chrome/10.0.601.0 Safari/534.14",
    "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.20 (KHTML, like Gecko) Chrome/11.0.672.2 Safari/534.20",
    "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.27 (KHTML, like Gecko) Chrome/12.0.712.0 Safari/534.27",
    "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.24 Safari/535.1",
    "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/535.2 (KHTML, like Gecko) Chrome/15.0.874.120 Safari/535.2",
    "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.36 Safari/535.7",
    "Mozilla/5.0 (Windows; U; Windows NT 6.0 x64; en-US; rv:1.9pre) Gecko/2008072421 Minefield/3.0.2pre",
    "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10",
    "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)",
    "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.6) Gecko/20091201 Firefox/3.5.6 GTB5",
    "Mozilla/5.0 (Windows; U; Windows NT 5.1; tr; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8 ( .NET CLR 3.5.30729; .NET4.0E)",
    "Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1",
    "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:2.0.1) Gecko/20100101 Firefox/4.0.1",
    "Mozilla/5.0 (Windows NT 5.1; rv:5.0) Gecko/20100101 Firefox/5.0",
    "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:6.0a2) Gecko/20110622 Firefox/6.0a2",
    "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:7.0.1) Gecko/20100101 Firefox/7.0.1",
    "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0b4pre) Gecko/20100815 Minefield/4.0b4pre",
    "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0 )",
    "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98; Win 9x 4.90)",
    "Mozilla/5.0 (Windows; U; Windows XP) Gecko MultiZilla/1.6.1.0a",
    "Mozilla/2.02E (Win95; U)",
    "Mozilla/3.01Gold (Win95; I)",
    "Mozilla/4.8 [en] (Windows NT 5.1; U)",
    "Mozilla/5.0 (Windows; U; Win98; en-US; rv:1.4) Gecko Netscape/7.1 (ax)",
    "HTC_Dream Mozilla/5.0 (Linux; U; Android 1.5; en-ca; Build/CUPCAKE) AppleWebKit/528.5  (KHTML, like Gecko) Version/3.1.2 Mobile Safari/525.20.1",
    "Mozilla/5.0 (hp-tablet; Linux; hpwOS/3.0.2; U; de-DE) AppleWebKit/534.6 (KHTML, like Gecko) wOSBrowser/234.40.1 Safari/534.6 TouchPad/1.0",
];
class ToolController extends Controller {

    //获取地图上的点位
    async getMapPoint() {
        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            house_style: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
            level: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const house_style = input_parmas.house_style;
        const area_code = input_parmas.area_code;
        const level = input_parmas.level;

        let ret = [];
        if (house_style === 'used_house') {
            ret = await ctx.service.house.tool.getUsedHouseMapPoint(area_code, level);
        } else if (house_style === 'new_house') {
            ret = await ctx.service.house.tool.getNewHouseMapPoint(area_code, level);
        }

        ctx.success({ results: ret });
    }

    //生成购房计划
    async generateBuyHousePlan() {

        const { ctx } = this;
        const input_parmas = ctx.request.body;
        const rule = {
            city_code: { type: 'string', required: true },
            down_payment: { type: 'string', required: true },
            invest_payment: { type: 'string', required: true }
        }
        ctx.validate(rule, input_parmas);

        const target_house = await ctx.blockModel.HousePriceMap.one({ where: { id: input_parmas.city_code } });
        let target_price = 0;
        if (target_house && target_house.price) {
            target_price = target_house.price;
        }
        const filter = {
            price: { min: target_price - 300000, max: target_price + 300000 },
        }
        const recommend_houses = await ctx.service.house.rentalHouse.getRentalHousesByFilter(filter);//推荐房源
        // const recommend_houses = [];//推荐房源

        const house_plan = await ctx.service.house.tool.generateHousePlan(input_parmas);//计算购房能力 生成购房计划
        const ret = {
            house_plan,
            recommend_houses,
        }

        ctx.success({ results: ret });
    }

    //type类型；trend：房价指数；increase：房价涨跌 ;question: 购房问题
    async getHousePriceFeature() {

        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            type: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const type = input_parmas.type;
        const area_code = input_parmas.area_code;
        let ret = [];
        if (type === 'trend') {
            ret = await ctx.blockModel.HousePriceTrend.one({ where: { id: area_code } });
            ret = ret.trend_json;
        } else if (type === 'increase') {
            ret = await ctx.blockModel.HouseQuestion.one({ where: { id: area_code } });
            ret = ret.increase_json;
        } else if (type === 'question') {
            ret = await ctx.blockModel.HouseQuestion.one({ where: { id: area_code } });
            ret = ret.question_json;
        }

        ctx.success(ret);
    }

    //房产估价
    async calculateHousePrice() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const rule = {
            residential_id: { type: 'string', required: true, },
            residential_name: { type: 'string', required: true, },
            area: { type: 'string', required: true },
            direction_str: { type: 'string', required: true },
            floor: { type: 'string', required: true },
            total_floor: { type: 'string', required: true },
        };
        ctx.validate(rule, input_params);
        const residential_id = input_params.residential_id;
        const residential_name = input_params.residential_name;
        const area = input_params.area;
        const direction_str = input_params.direction_str;
        const floor = input_params.floor;
        const total_floor = input_params.total_floor;
        const qfang_url_area = 'https://hangzhou.qfang.com/fangjia/area';
        const qfang_url_chaxun = `https://hangzhou.qfang.com/fangjia/chaxun?userName=&gardenId=&gardenInternalID=${residential_id}&name=${residential_name}&area=${area}&floor=${floor}&totlaFloor=${total_floor}&directionStr=${direction_str}&buildingId=&building=&roomNoId=&roomNo=&subQueryType=quick`;

        const ret1 = await ctx.curl(qfang_url_area, { method: 'POST' });
        const headers = ret1.headers;
        const cookies = headers['set-cookie'];
        let cookie = '';
        for (let i in cookies) {
            const cookie_items = cookies[i].split(';');
            cookie += cookie_items[0] + '; ';
        }
        const user_agent_length = USER_AGENT.length;
        const random = Math.floor(Math.random() * user_agent_length);
        const user_agent = USER_AGENT[random];

        const ret2 = await ctx.curl(qfang_url_chaxun, {
            headers: {
                'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8',
                'accept-encoding': 'gzip, deflate, br',
                'accept-language': 'zh-CN,zh;q=0.9,en;q=0.8',
                'cache-control': 'max-age=0',
                'cookie': cookie,
                // 'referer': qfang_url_chaxun,//不能加 一加就报错
                'upgrade-insecure-requests': 1,
                'user-agent': user_agent,
            }
        });

        ctx.logger.info('qfang_url_chaxun_result: ' + JSON.stringify(ret2));
        if(ret2.status !== 200){
            ctx.failed('估算过程中出了点错，请稍后再试！');
        }

        const html = ret2.data.toString('utf8');
        const $ = cheerio.load(html);
        const average_price = $('p.title-result').text();
        // const total_price = $('#targetNum').html();
        const total_price = $('span.average-price', '.fl').text();

        if (!average_price || !total_price) {
            ctx.failed('估算过程中出了点错，请稍后再试！');
        }

        ctx.success({ average_price, total_price });
    }

    async getQFangAreaList() {

        const { ctx } = this;
        const input_parmas = ctx.query;
        const rule = {
            keyword: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const qfang_url = 'https://hangzhou.qfang.com/fangjia/getGarden';
        const keyword = encodeURIComponent(input_parmas.keyword);
        const result = await ctx.helper.send_request(qfang_url + '?keyword=' + keyword, {}, { dataType: 'json' });
        let ret = [];
        if (result.status === 200 && result.data && result.data.items) {
            const residential_items = result.data.items;
            for (let i in residential_items) {
                const residential_item = residential_items[i];
                ret.push({
                    residential_id: residential_item.id,
                    residential_name: residential_item.name,
                });
            }
        }

        ctx.success({ ret: ret });
    }
}

module.exports = ToolController;
