
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class YysService extends Service {


    /**
     * 创建订单号
     * @param {*} 
     */
    async getOrderSn({ phone, net }) {
        const { ctx } = this;
        let params = {
            phone: phone,
            net: Number(net),
        }
        let url = this.config.NODE_BASE_URL + '/yys_api/getorderSn' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST', timeout: 30000 });
        ctx.logger.info(JSON.stringify({ yys_getorderSn_params: params, yys_getorderSn_result: resp }));
        if (resp.data.code === undefined || resp.data.code !== 0) {
            ctx.failed('getorderSn error:' + resp.data.msg);
        }
        let order_sn = resp.data.data.orderSn;
        await this.addCreditLogYys(order_sn, '/yys_api/getorderSn', params, resp.data);
        // ctx.logger.info(JSON.stringify(resp));
        // ctx.logger.info(JSON.stringify({ yys_getorderSn_params: params, yys_getorderSn_result: resp }));
        return resp.data;
    }

    /**
    * 获取验证码
    * @param {*} 
    */
    async getCode(params) {
        const { ctx } = this;
        // let params_data = {
        //     orderSn: params.order_sn,
        //     data: {
        //         password: params.password
        //     }
        // }
        let url = this.config.NODE_BASE_URL + '/yys_api/getCode' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST', timeout: 30000 });
        ctx.logger.info(JSON.stringify({ yys_getCode_params: params, yys_getCode_result: resp }));
        await this.addCreditLogYys(params.orderSn, '/yys_api/getCode', params, resp.data);
        // console.info(resp);
        return resp.data;
    }


    /**
    * 提交任务
    * @param {*} params 需要提交的参数,根据getOrderSn的operator来确定需要的参数
    */
    async commit(params) {

        const { ctx } = this;
        // let params = {
        //     orderSn: params.order_sn,
        //     params: {
        //         password: params.password
        //     }
        // }
        const url = this.config.NODE_BASE_URL + '/yys_api/commit' + '?appKey=' + this.config.YYS_APP_KEY;
        const resp = await ctx.helper.send_request(url, params, { method: 'POST', timeout: 30000 });
        ctx.logger.info(JSON.stringify({ yys_commit_params: params, yys_commit_result: resp }));
        await this.addCreditLogYys(params.orderSn, '/yys_api/commit', params, resp.data);
        return resp.data;
    }

    /**
    * 查询任务状态
    * @param {*} orderSn 创建订单时生成的订单号
    */
    async query(orderSn) {
        const { ctx } = this;
        let params = {
            orderSn: orderSn,
        }
        let url = this.config.NODE_BASE_URL + '/yys_api/query' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST', timeout: 30000 });
        ctx.logger.info(JSON.stringify({ yys_query_params: params, yys_query_result: resp }));
        await this.addCreditLogYys(orderSn, '/yys_api/query', params, resp.data);
        return resp.data;
    }

    /**
    * 获取报告
    * @param {*} orderSn 创建订单时生成的订单号
    */
    async getData(orderSn) {

        const { ctx } = this;

        //调用数据接口获取通话检测报告数据
        let params = {
            sign: "",
            signParams: {
                appKey: this.config.YYS_REPORT_KEY,
                timestamp: String(new Date().getTime()),
            },
            orderSn,
        }
        params.sign = await ctx.service.credit.common.sign(params.signParams, this.config.YYS_REPORT_APPSECRET);
        const url = this.config.YYS_REPORT_URL;
        const result = await ctx.helper.send_request(url, params, { method: 'POST', timeout: 30000 });
        ctx.logger.info(JSON.stringify({ thxdReport_parmas: params, thxdReport_result: result }));
        return result.data;

    }

    async addCreditLogYys(order_sn, request_url, params, resp) {

        const { ctx } = this;
        const user_id = ctx.userId;
        const app_type_id = ctx.appTypeId;
        const app_user_id = ctx.appUserId;
        const app_id = ctx.appId;
        const log_data = { user_id, app_type_id, app_user_id, app_id, r_order_sn: order_sn, request_url, params: JSON.stringify(params), resp: JSON.stringify(resp) }

        const ret = await ctx.prometheusModel.CreditLogYys.create(log_data);

        return ret;
    }


}

module.exports = YysService;
