'use strict';

module.exports = app => {
  const { INTEGER, STRING, TEXT } = app.Sequelize;

  const Setting = app.blockModel.define('setting', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    code: STRING(32),
    keyword: STRING(64),
    value: TEXT,
    is_json: INTEGER(2),
  }, {
    timestamps: false,
    tableName: 'setting',
  });

  Setting.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Setting.findOne({
      attributes,
      where,
    });
  };

  return Setting;

};
