'use strict';

const Controller = require('egg').Controller;

class NewHouseController extends Controller {

    /**
     * 新房列表
     * 全部all 在售sale 最近开盘open 优惠favourtable 首页home
     */
    async getNewHouseList() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const ret = await ctx.service.house.newHouse.getNewHouseList(inputParams.type);
        ctx.success(ret);
    }

    /**
     * 新房具体信息
     */
    async getNewHouse() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const ret = await ctx.service.house.newHouse.getNewHouse(inputParams.id);
        ctx.success(ret);
    }

    /**
     * 新房户型信息
     */
    async getNewHouseType() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const ret = await ctx.service.house.newHouse.getNewHouseType(inputParams.id);
        ctx.success(ret);
    }

}

module.exports = NewHouseController;
