'use strict';

const Controller = require('egg').Controller;

class CallriskController extends Controller {

    /**
     * 获取黑名单报告
     */
    async getReport() {

        const { ctx } = this;
        const report_id = ctx.params.report_id;
        if (!report_id) {
            ctx.failed('error report id');
        }
        let ret = await ctx.service.credit.callrisk.getReport(report_id);
        ctx.success(ret);

    }

    /**
     * 进入个人通话风险检测页面
     */
    async callriskInit() {
        const { ctx } = this;
        let ret = await ctx.service.credit.apply.callriskInit();
        ctx.success(ret);
    }

    /**
     * 获取数据报告信息
     */
    async applyCallriskReport() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            phone: { type: 'string', required: true },
            id_card: { type: 'string', required: true },
            code: { type: 'string', required: true }
        }
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.credit.apply.applyCallrisk(inputParams);
        ctx.success(ret);
    }


}

module.exports = CallriskController;
