'use strict';

const Controller = require('egg').Controller;

class UserController extends Controller {
    /**
     * 获取用户的手机号
     */
    async getUserPhone() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            code: { type: 'string', required: true },
            iv: { type: 'string', required: true },
            encryptedData: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.user.getUserWxPhone(inputParams);
        ctx.success(ret);
    }

    /**
     * 用户注册获取登录信息
     */
    async userRegister() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            phone: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.user.register(inputParams.phone);
        ctx.success(ret);
    }

}

module.exports = UserController;
