'use strict';

const Service = require('egg').Service;

class ResidentialService extends Service {

    //根据Id,获取新房信息表
    async one(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential/' + id, {}, { method: 'GET' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    //修改新房信息表
    async edit(id, data) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential/' + id, data, { method: 'PUT' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    //根据Id,删除新房信息表
    async delete(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential/' + id, {}, { method: 'DELETE' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    //获取新房信息表信息(分页)
    async all(data) {
        const { ctx } = this;
        const queryConditions = data.queryConditions;
        const sum = queryConditions.length;
        for (let i = 0; i < sum; i++) {
            if (queryConditions[i].key === 'userId' && queryConditions[i].value.length === 0) {
                queryConditions[i].value = true;
                queryConditions[i].operator = 'isnull';
            }
        }
        data.queryConditions = queryConditions;
        if (Object.keys(data.orderConditions).length === 0) {
            data.orderConditions = [{
                key: 'createdAt',
                orderSequence: 'desc',
            }];
        }

        ctx.logger.info('get_newHouse_filter: ' + JSON.stringify(data));

        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential/list', data, { method: 'POST' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    //新增新房信息表
    async add(data) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential/', data, { method: 'POST' });
        if (result.status !== 201) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

}

module.exports = ResidentialService;
