
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CreditCallriskCallOverview = app.prometheusModel.define('credit_callrisk_call_overview', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        report_id: {
            type: INTEGER,
            allowNull: false,
        },
        month: {
            type: INTEGER,
            allowNull: false,
        },
        call_time_month: {
            type: INTEGER,
            allowNull: false,
        },
        call_fee_month: {
            type: INTEGER,
            allowNull: false,
        },
        call_active_count_month: {
            type: INTEGER,
            allowNull: false,
        },
        call_passive_count_month: {
            type: INTEGER,
            allowNull: false,
        },
        call_count_month: {
            type: INTEGER,
            allowNull: false,
        },
        // is_deleted: {
        //     type: INTEGER,
        //     allowNull: false,
        // },
        // updated_at: {
        //     type: DATE,
        //     allowNull: true,
        //     get() {
        //         const date = this.getDataValue('updated_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // },
        // created_at: {
        //     type: DATE,
        //     allowNull: false,
        //     get() {
        //         const date = this.getDataValue('created_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // }
    }, {
            timestamps: false,
            tableName: 'credit_callrisk_call_overview',
        });

    CreditCallriskCallOverview.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditCallriskCallOverview.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditCallriskCallOverview.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditCallriskCallOverview.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditCallriskCallOverview.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditCallriskCallOverview.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditCallriskCallOverview.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditCallriskCallOverview.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditCallriskCallOverview.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditCallriskCallOverview.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditCallriskCallOverview;

};