'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE } = app.Sequelize;
    const CreditShuhemofang = app.prometheusModel.define('credit_shuhemofang', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        type: INTEGER,
        user_id: STRING,
        app_user_id: STRING,
        app_id: STRING,
        app_type_id: STRING,
        name: STRING,
        phone: STRING,
        id_card: STRING,
        status: STRING,
        response: STRING,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
        timestamps: false,
        tableName: 'credit_shuhemofang',
    });

    return CreditShuhemofang;

};
