'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/house');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件


    router.get('/tool/:house_style/:area_code/:level', 'house.tool.getMapPoint');//购房计划地图点位
    router.post('/tool/plan', 'house.tool.generateBuyHousePlan');//生成购房计划
    router.get('/tool/:type/:area_code', 'house.tool.getHousePriceFeature');//房价指数 房价涨跌 购房资格、贷款额度问答
    router.post('/tool/calculate_price', 'house.tool.calculateHousePrice');//房产估价
    router.get('/tool/qfang_area_list', 'house.tool.getQFangAreaList');//房产估价模糊匹配到的小区列表
    router.get('/tool/map_houses', 'house.tool.getMapHouses');//房产估价模糊匹配到的小区列表

    //租房
    router.get('/rental_house/home', 'house.rentalHouse.home');//租房首页信息
    router.get('/rental_house/list', 'house.rentalHouse.getRentalHouses');//租房列表
    router.post('/rental_house/list', 'house.rentalHouse.getRentalHouses');//租房列表
    router.get('/rental_house/info/:rental_house_id', 'house.rentalHouse.getRentalHouse');//租房详情
    router.get('/options/:city_code', 'house.options.getOptions');//筛选项信息


    //新房
    router.post('/new_house/list', 'house.newHouse.getNewHouseList');//根据条件筛选列表
    router.get('/new_house/:id', 'house.newHouse.getNewHouse');//新房具体信息
    router.get('/new_house_type/:id', 'house.newHouse.getNewHouseType');//新房户型
    router.get('/new_house/options/:city_code', 'house.options.getNewHouseOptions');//筛选项信息

    //预约
    router.post('/order', loginAuth, 'house.order.addOrder');//预约
    router.get('/order/list', loginAuth, 'house.order.getOrderList');//预约列表

    //关注
    router.post('/collection', loginAuth, 'house.collection.addCollection');//关注
    router.get('/collection/list', loginAuth, 'house.collection.getCollectionList');//关注列表
    router.put('/collection', loginAuth, 'house.collection.unCollection');//取消关注

    //搜索历史
    router.get('/search_history', 'house.searchHistory.getsearchHistory');//搜索历史
    router.put('/search_history/:type', 'house.searchHistory.cleanSearchHistory');//用户点击清除搜索记录

    //足迹
    router.get('/foot_print/list', 'house.footPrint.getFootPrintList');//用户浏览记录列表

    //我的
    router.get('/mine', 'house.mine.getMineInfo');//获取用户的头像昵称和关注等信息




    //房产v2
    router.get('/v2/tool/:house_style/:area_code/:level', 'house.v2.tool.getMapPoint');//购房计划地图点位(存钱罐地图)（房价地图）
    router.post('/v2/tool/plan', 'house.v2.tool.generateBuyHousePlan');//生成购房计划
    router.post('/v2.1/tool/plan', 'house.v2.tool.generateBuyHousePlan_2_1');//生成购房计划
    router.get('/v2/tool/plan_area_list', 'house.v2.tool.planAreaList');//购房计划页面 区域列表接口
    router.get('/v2/tool/:type/:city_code', 'house.v2.tool.getHousePriceFeature');//房价走势图 房价涨跌图 购房资格图、贷款额度问答、供需趋势图
    router.get('/v2/tool/house_qusetion_city', 'house.v2.tool.getHouseQuestionCity');//购房资格问题支持的城市
    router.post('/v2/tool/calculate_price', 'house.tool.calculateHousePrice');//房产估价
    router.get('/v2/tool/qfang_area_list', 'house.tool.getQFangAreaList');//房产估价模糊匹配到的小区列表
    router.get('/v2/tool/map_houses', 'house.tool.getMapHouses');//房产估价模糊匹配到的小区列表
    router.get('/v2/tool/house_price_feature_city', 'house.v2.tool.getHousePriceFeatureCity');//房价指数 城市月参考价支持的城市
    router.get('/v2/tool/house_price_city', 'house.v2.tool.getHousePriceCity');//房价指数 城市月参考价
    router.post('/v2/tool/house_price_search', 'house.v2.tool.getHousePriceFeatureSearch');//房价指数 搜索结果
    router.get('/v2/tool/house_point', 'house.v2.tool.getHousePoint');//点击房源信息跳到地图页 需要的经纬度信息。
    router.post('/v2/tool/nearby_house_points', 'house.v2.tool.getHouseNearbyPoint');//点击房源信息跳到地图页 此房源周边信息。
    router.get('/v2/tool/oss_signature', 'house.v2.tool.getBusinessSignature');//上传图片需要的签名参数。


    //租房列表
    router.get('/v2/rental_house/home', 'house.v2.rentalHouse.home');//租房首页信息
    router.get('/v2/rental_house/list', 'house.v2.rentalHouse.getRentalHouses');//租房列表
    router.post('/v2/rental_house/list', 'house.v2.rentalHouse.getRentalHouses');//租房列表
    router.get('/v2/rental_house/info/:rental_house_id', 'house.v2.rentalHouse.getRentalHouse');//住房详情
    router.get('/v2/options/:city_code', 'house.v2.options.getOptions');//筛选项信息
    router.get('/v2/rental_house/list/recommend', 'house.v2.rentalHouse.getRecommendRentalHouses');//推荐的租房楼盘 基本可通用

    //足迹
    router.get('/v2/foot_print/list', 'house.v2.footPrint.getFootPrintList');//用户浏览记录列表


    //新房
    router.post('/v2/new_house/list', 'house.v2.newHouse.getNewHouseList');//根据条件筛选列表
    router.get('/v2/new_house/:id', 'house.v2.newHouse.getNewHouse');//新房具体信息
    router.get('/v2/new_house/options/:city_code', 'house.v2.options.getNewHouseOptions');//筛选项信息
    router.get('/v2/new_house/list/recommend/', 'house.v2.newHouse.getRecommendNewHouses');//推荐的新房楼盘 基本可通用
    router.get('/v2/new_house/city/list', 'house.v2.newHouse.getNewHouseCity');//新房支持的城市
    router.get('/v2/new_house/city/price', 'house.v2.newHouse.getNewHouseCityPrice');//新房支持的城市


    //关注
    router.post('/v2/collection', loginAuth, 'house.v2.collection.addCollection');//关注
    router.get('/v2/collection/list', loginAuth, 'house.v2.collection.getCollectionList');//关注列表
    router.put('/v2/collection', loginAuth, 'house.v2.collection.unCollection');//取消关注

    //预约
    router.post('/v2/order', loginAuth, 'house.v2.order.addOrder');//预约
    router.get('/v2/order/list', loginAuth, 'house.v2.order.getOrderList');//预约列表

    //搜索历史
    router.get('/v2/search_history/:city_code', 'house.v2.searchHistory.getSearchHistory');//搜索历史
    router.put('/v2/search_history/:type', 'house.v2.searchHistory.cleanSearchHistory');//用户点击清除搜索记录
    router.get('/v2/hot_question/search_history', 'house.v2.searchHistory.getHotQuestionSearchHistory');//热门问题搜索历史

    //我的
    router.get('/v2/mine', 'house.v2.mine.getMineInfo');//获取用户的头像昵称和关注等信息

    //
    router.get('/v2/tool/gjj/loan/measure/:area', 'house.v2.tool.gjjLoanMeasureInfo');//貸款測算

    //户型解析
    router.get('/v2/house_analysis/list', 'house.v2.houseAnalysis.getHouseAnalysisList');//户型解析列表
    router.post('/v2/house_analysis/list', 'house.v2.houseAnalysis.getHouseAnalysisList');//户型解析列表
    router.get('/v2/house_analysis/info/:house_analysis_id', 'house.v2.houseAnalysis.getHouseAnalysisInfo');//户型解析列表
    router.post('/v2/house_analysis/', loginAuth, 'house.v2.houseAnalysis.uploadHouseAnalysis');//上传户型信息
    // router.post('/v2.1/house_analysis/', loginAuth, 'house.v2.houseAnalysis.uploadHouseAnalysis_2_1');//上传户型信息
    router.get('/v2/house_analysis/mine', 'house.v2.houseAnalysis.getUserHouseAnalysis');//我的户型
    router.get('/v2/house_analysis/city_list', 'house.v2.houseAnalysis.getHouseAnalysisSupportCity');//上传户型解析的城市列表

    //提问
    router.post('/v2/question', loginAuth, 'house.v2.question.addQuestion');//提问
    router.post('/v2/question/mine', loginAuth, 'house.v2.question.mineQuestion');//我的问题
    router.post('/v2/question/list', 'house.v2.question.questionList');//问题列表
    router.post('/v2/question/detail', 'house.v2.question.questionDetail');//问题详情

    //回答
    router.post('/v2/answer', loginAuth, 'house.v2.answer.answer');//回答

    //点赞回答
    router.post('/v2/answer/like/:id', loginAuth, 'house.v2.like.like');//点赞
    router.put('/v2/answer/like/:id', loginAuth, 'house.v2.like.unLike');//取消点赞



};