'use strict';


const moment = require('moment');

module.exports = app => {
  const { TEXT, INTEGER, DATE } = app.Sequelize;

  const CourseWechatLog = app.classModel.define('course_wechat_log', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    type: INTEGER,
    title: TEXT,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_wechat_log',
  });

  return CourseWechatLog;

};
