'use strict';

const Controller = require('egg').Controller;

class LotteryPubliciseController extends Controller {
    /**
     * 用户输入楼盘的名字模糊匹配所有的楼盘
     */
    async getHouseName() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            name: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.lotteryPublicise.getHouseName(inputParams.name);
        ctx.success(ret);
    }

    /**
     * 用户输入楼盘名字,摇号编号,手机号,查询摇号楼盘结果
     */
    async getLotteryPublicise() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            name: { type: 'string', required: true },
            no: { type: 'string', required: true },
            phone: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.lotteryPublicise.getLotteryPublicise(inputParams);
        ctx.success(ret);
    }

    /**
     * 用户所有查询过的摇号编号
     */
    async getUserQueryList() {
        const { ctx } = this;
        let ret = await ctx.service.cd.lotteryPublicise.getUserQueryList();
        ctx.success(ret);
    }

    /**
     * 更新查询
     */
    async updateQuery() {
        const { ctx } = this;
        let inputParams = ctx.params;
        let inputParams = ctx.request.body;
        let rule = {
            id: { type: 'integer', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.lotteryPublicise.getPubliciseByQueryId(Number(inputParams.id));
        ctx.success(ret);
    }



}

module.exports = LotteryPubliciseController;
