
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class SmsService extends Service {

    /**
     * 短信接口
     * @param {object} inputParams phone和content必须
     */
    async sendSms(inputParams) {
        const { ctx } = this;
        if (!inputParams.hasOwnProperty('phone') || !inputParams.hasOwnProperty('content')) {
            ctx.failed('手机号/短信内容不能为空');
        }
        const url = 'https://b.jianbing.com/messages/index';
        const appId = 'cXeKaF53GQgQk55';
        const appKey = '276BC440-B67E-44DA-ADC0-944A79F0DAB0';
        let params = {
            app_id: appId,
            timestamp: new Date().getTime(),
            sign: '',
            params: {
                phone: inputParams.phone,
                content: inputParams.content,
            }
        }
        params.sign = await ctx.helper.md5(params.timestamp + '&' + appKey);
        if (!(/【51公积金】/.test(params.params.content))) {
            params.params.content = '【51公积金】' + params.params.content;
        }
        if (inputParams.hasOwnProperty('schedule')) {
            params.params.schedule = inputParams.schedule;
        }
        let result = await ctx.helper.send_request(url, params, { method: 'POST' });
        return result;
    }



}

module.exports = SmsService;
