'use strict';

const Controller = require('egg').Controller;

class LikeController extends Controller {
    /**
     * 贷款计算器
     */
    async caculator() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            type: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        if (inputParams.type === 'commercial') {
            let rule = {
                commercial: { type: 'object', required: true },
            };
            ctx.validate(rule, inputParams);
            let params = {
                total: { type: 'int', required: true },//贷款额
                years: { type: 'int', required: true },//年限
                lpr: { type: 'number', required: true },//lpr
                basic_point: { type: 'number', required: true },//基点
            };
            ctx.validate(params, inputParams.commercial);
        } else if (inputParams.type === 'gjj') {
            let rule = {
                gjj: { type: 'object', required: true },
            };
            ctx.validate(rule, inputParams);
            let params = {
                total: { type: 'int', required: true },//贷款额
                years: { type: 'int', required: true },//年限
                rate: { type: 'number', required: true },//利率
            };
            ctx.validate(params, inputParams.gjj);
        } else if (inputParams.type === 'combination') {
            let rule = {
                commercial: { type: 'object', required: true },
                gjj: { type: 'object', required: true },
            };
            ctx.validate(rule, inputParams);

            let paramsCommercial = {
                total: { type: 'int', required: true },//贷款额
                years: { type: 'int', required: true },//年限
                lpr: { type: 'number', required: true },//lpr
                basic_point: { type: 'number', required: true },//基点
            };
            ctx.validate(paramsCommercial, inputParams.commercial);

            let paramsGjj = {
                total: { type: 'int', required: true },//贷款额
                years: { type: 'int', required: true },//年限
                rate: { type: 'number', required: true },//利率
            };
            ctx.validate(paramsGjj, inputParams.gjj);
        } else {
            ctx.failed('error type');
        }
        let ret = await ctx.service.cd.loanCaculator.getLoanCaculatorResult(inputParams);
        ctx.success(ret);
    }



}

module.exports = LikeController;
