
'use strict';

const Service = require('egg').Service;

const PRICE_RANGE = [
    { name: '2000元以下', min: 0, max: 2000 },
    { name: '2000元-3000元', min: 2000, max: 3000 },
    { name: '3000元-4000元', min: 3000, max: 4000 },
    { name: '4000元-5000元', min: 4000, max: 5000 },
    { name: '5000元-6000元', min: 5000, max: 6000 },
    { name: '6000元-7000元', min: 6000, max: 7000 },
    { name: '7000元-8000元', min: 7000, max: 8000 },
    { name: '8000元-10000元', min: 8000, max: 10000 },
    { name: '10000元以上', min: 10000, max: 10000000000000 },
]

const HOUSE_TYPE = [
    { name: '1室', min: 1, max: 1, value: 1, },
    { name: '2室', min: 2, max: 2, value: 2, },
    { name: '3室', min: 3, max: 3, value: 3, },
    { name: '4室', min: 4, max: 4, value: 4, },
    { name: '5室以上', min: 5, max: 10000, value: 5, },
    { name: '别墅', min: 10000, max: 10000000, value: 6, },
]

class OptionService extends Service {

    //获取筛选项
    async getOptions(city_code) {

        const brands = await this.getDevelopers();
        const house_types = HOUSE_TYPE;
        const prices = PRICE_RANGE;
        const areas = await this.getAreaOptions(city_code);

        return { result: { brands, prices, house_types, areas } };
    }

    //获取开发商列表
    async getDevelopers() {

        const { ctx } = this;
        const developers_results = await ctx.service.houseCommon.developer.all({});
        const developers = developers_results.results;
        const ret = [];
        for (let i in developers) {
            const developer = developers[i];
            ret.push({
                id: developer.id,
                name: developer.name,
                image: developer.logo,
            });
        }

        return ret;
    }

    //获取区域商圈
    async getAreaOptions(city_code) {
        const { ctx } = this;
        const city = await ctx.blockModel.City.one({ where: { code: city_code } });
        if (!city || !city.name) {
            ctx.failed('city code error');
        }
        const districts = await ctx.blockModel.HouseDistrict.all({ where: { city_id: city.code } });
        if (!districts || districts.length === 0) {
            ctx.failed('district error');
        }

        const ret = []
        for (let j in districts) {
            const district = districts[j];
            const _children = [];
            const bizcircles = await ctx.blockModel.HouseBizcircle.all({ where: { district_id: district.id } });
            if (!bizcircles || bizcircles.length === 0) {
                continue;
            }
            for (let i in bizcircles) {
                const bizcircle = bizcircles[i];
                _children.push({
                    id: bizcircle.id,
                    area_name: bizcircle.name,
                    // district_id: bizcircle.district_id,
                });
            }
            ret.push({
                id: district.id,
                area_name: district.name,
                // city_id: district.city_id,
                _children: _children,
            })

        }

        return ret;
    }
}

module.exports = OptionService;
