'use strict';

const Controller = require('egg').Controller;

class NewHouseController extends Controller {
    /**
     * 根据筛选条件获得新房列表
     */
    async getNewHouseList() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            page: { type: 'string', required: false },//页面
            page_size: { type: 'string', required: false },//条数

            area_code: { type: 'object', required: false },//区域
            unit_price: { type: 'object', required: false },//价格
            total_price: { type: 'object', required: false },//总价
            area: { type: 'object', required: false },//面积
            house_type: { type: 'string', required: false },//房型

            //通过type选择指定内容 全部all 在售sale 最近开盘open 优惠favourtable 首页home,和上面的筛选项互斥
            type: { type: 'string', required: false },//
        };
        ctx.validate(rule, inputParams);
        let ret = {};
        ret = await ctx.service.house.newHouse.getNewHouseList(inputParams);
        ctx.success(ret);
    }

    /**
     * 新房具体信息
     */
    async getNewHouse() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const ret = await ctx.service.house.newHouse.getNewHouse(inputParams.id);
        ctx.success(ret);
    }

    /**
     * 新房户型信息
     */
    async getNewHouseType() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const ret = await ctx.service.house.newHouse.getNewHouseType(inputParams.id);
        ctx.success(ret);
    }
}

module.exports = NewHouseController;
