'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM, FLOAT } = app.Sequelize;
  const Bank = app.businessModel.define('bank', {
    id: { type: STRING, primaryKey: true },
    name: STRING,
    product_cid: INTEGER,
    yys_cid: INTEGER,
    slag: STRING,
    logo: STRING,
    interest_title: STRING,
    interest_type: INTEGER,
    interest_rate: STRING,
    terms_title: STRING,
    terms_show: STRING,
    terms_limit: STRING,
    tags: STRING,
    tag_images: STRING,
    date_added: DATE,
    sort_order: INTEGER,
    status:INTEGER,
    consis_month:INTEGER,
    exist_month:INTEGER,
    loan_min:FLOAT,
    loan_max:FLOAT,
    deposit_base:INTEGER,
    deposit:INTEGER,
    type:INTEGER,
    card_front:STRING,
    card_back:STRING,
    card_background:STRING,
    applys:INTEGER,
    partner:STRING,
    partner_url:STRING,
    hot:INTEGER,
    recommend:INTEGER,
    joins:INTEGER,
    new:INTEGER,
    redpaper:INTEGER,
    server_status:INTEGER,
    suspend_end_time:INTEGER,
    suspend_message:STRING,
    suspend_start_time:INTEGER,
    server_time:STRING,
    reject:STRING,
    credit_status:INTEGER,
    age_min:INTEGER,
    age_max:INTEGER,
    kind:STRING,
    certification_status:INTEGER,
    date_open:DATE,
    point:STRING,
    cities:STRING,
    cities_cid:STRING,
    pass:INTEGER,
    pass_rate:INTEGER,
    deposit_base_status:INTEGER,
    high:INTEGER,
    current:INTEGER,
    authentication:STRING,
    insurance:STRING,
    question:STRING,
    low:INTEGER,
    offer:INTEGER,
    suit_people:STRING,
    card_level:STRING,
    url:STRING,
    reason:STRING,
    perferential:STRING,
    point_image:STRING,
    loan_max_title:STRING,
    loan_min_title:STRING,
    advantages:STRING,
    notice:STRING,
    description:STRING,
    activity:STRING,
    privilege:STRING,
    matches:STRING,
    sort_order_yongbei:INTEGER,
    sort_order_jiebei:INTEGER,
    loan_credit:STRING,
    loan_period:STRING,
    is_old_business:INTEGER,
    loan_credit_text:STRING,
    loan_period_text:STRING,
    final_credit_text:STRING,
    final_period_text:STRING,
    final_credit:STRING,
    final_period:STRING,
    bank_groups:STRING,
    is_new_button:INTEGER,
    is_show_app_index:INTEGER,
    v_apply_num:INTEGER,
    peak_time_growth:STRING,
    trough_time_growth:STRING,
    bank_key:STRING,
    bank_secret:STRING,
    daily_suspend_start:STRING,
    daily_suspend_end:STRING,
    submit_status:INTEGER,
    repay_status:INTEGER,
    bill_exist_month:INTEGER,
    bill_card_limit:INTEGER,
    bill_continue_month:INTEGER,   

  }, {
    timestamps: false,
    tableName: 'cfg_bank',
  });

  Bank.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Bank.findOne({
      attributes,
      where,
    });
  };


  Bank.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await Bank.findAll({
      attributes,
      where,
      order,
    });
  };

  Bank.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await Bank.findAndCountAll(condition);
    return { page, count, rows };
  };

  return Bank;

};
