'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, TEXT, DATE } = app.Sequelize;
    const CdNews = app.realestateModel.define('cd_news', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        title: {
            type: STRING,
            allowNull: true
        },
        images: {
            type: STRING,
            allowNull: true
        },
        source: {
            type: STRING,
            allowNull: true
        },
        source_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('source_time');
                return date;
            },
        },
        content: {
            type: TEXT,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        author: {
            type: STRING,
            allowNull: true
        },
        top: {
            type: STRING,
            allowNull: true
        },
        top_start: {
            type: DATE,
            get() {
                const date = this.getDataValue('top_start');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        top_end: {
            type: DATE,
            get() {
                const date = this.getDataValue('top_end');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        initial_num: {
            type: INTEGER,
            allowNull: true
        },
        hourly_growth: {
            type: INTEGER,
            allowNull: true
        },
        status: {
            type: ENUM('pass', 'refuse', 'wait'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        operator: {
            type: STRING,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
        timestamps: false,
        tableName: 'cd_news',
    });

    return CdNews;

};
