'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, DATE, TEXT, DECIMAL } = app.Sequelize;
    const Residential = app.realestateModel.define('residential', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        name: STRING,
        province: INTEGER,
        city: INTEGER,
        county: INTEGER,
        region: INTEGER,
        property_right_years: INTEGER,
        property_fee: STRING,
        property_company: STRING,
        heat_supply_type: STRING,
        water_suppler_type: STRING,
        power_suppler_type: STRING,
        land_area: DECIMAL,
        house_area: DECIMAL,
        area_ratio: DECIMAL,
        green_ratio: DECIMAL,
        arch_type: INTEGER,
        nearby: TEXT,
        remark: STRING,
        status: ENUM('online', 'offline'),
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'residential',
        });

    Residential.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await Residential.findOne({
            attributes: attributes,
            where: where,
        });
    }

    Residential.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await Residential.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    Residential.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await Residential.findAndCountAll(condition);
        return { page, count, rows };
    }

    Residential.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await Residential.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    Residential.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            return res = await Residential.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return Residential;

};
