'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, DATE } = app.Sequelize;
    const Developer = app.realestateModel.define('developer', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        address: {
            type: STRING,
            allowNull: true
        },
        name: {
            type: STRING,
            allowNull: true
        },
        logo: {
            type: STRING,
            allowNull: true
        },
        order_id: {
            type: INTEGER,
            allowNull: true
        },
        description: {
            type: STRING,
            allowNull: true
        },

        status: ENUM('online', 'offline'),
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'developer',
        });

    Developer.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await Developer.findOne({
            attributes: attributes,
            where: where,
        });
    }


    Developer.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await Developer.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    Developer.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await Developer.findAndCountAll(condition);
        return { page, count, rows };
    }

    Developer.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await Developer.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    Developer.edit = async (data) => {

        const where = data.where;
        const params = data.params;
        try {
            return res = await Developer.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return Developer;

};
