'use strict';
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CourseOnlineClassToCat = app.classModel.define('course_online_class_to_cat', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        class_id: INTEGER,
        cat_id: INTEGER,
        status: ENUM('offline', 'online'),
        is_deleted: INTEGER,
        created_time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'course_online_class_to_cat',
        });

    CourseOnlineClassToCat.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CourseOnlineClassToCat.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CourseOnlineClassToCat.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CourseOnlineClassToCat.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CourseOnlineClassToCat.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CourseOnlineClassToCat.findAndCountAll(condition);
        return { page, count, rows };
    }

    CourseOnlineClassToCat.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CourseOnlineClassToCat.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CourseOnlineClassToCat.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CourseOnlineClassToCat.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CourseOnlineClassToCat;

};