'use strict';

const moment = require('moment');
module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;
  const AppUpdateInfo = app.blockModel.define('app_update_info', {
    id: { type: INTEGER, primaryKey: true },
    app_id: STRING,
    url: STRING,
    title: STRING,
    subhead: STRING,
    content: INTEGER,
    size: STRING,
    type: INTEGER,
    target_version: STRING,
    start_version: STRING,
    end_version: STRING,
    status: INTEGER,
    update_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('update_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'app_update_info',
  });

  return AppUpdateInfo;

};
