'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, TEXT, DECIMAL } = app.Sequelize;
    const CreditLogOrder = app.prometheusModel.define('credit_log_order', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        order_id: INTEGER,
        name: STRING,
        phone: STRING,
        id_card: STRING,
        type: INTEGER,
        price: DECIMAL,
        preferential_id: INTEGER,
        preferential_price: DECIMAL,
        final_price: DECIMAL,
        state: STRING,
        state_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('state_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        pay_status: STRING,
        pay_method: STRING,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'credit_log_order',
        });

    CreditLogOrder.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditLogOrder.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditLogOrder.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditLogOrder.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditLogOrder.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditLogOrder.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditLogOrder.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditLogOrder.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditLogOrder.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditLogOrder.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditLogOrder;

};
