'use strict';
const moment = require('moment');
module.exports = app => {
    const { INTEGER, STRING, DATE } = app.Sequelize;

    const UserAppFeedback = app.huodongModel.define('sys_user_app_feedback', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        user_sid: {
            type: INTEGER,
            allowNull: false,
        },
        score: {
            type: INTEGER,
            allowNull: false,
        },
        content: {
            type: STRING,
            allowNull: false,
        },
        system: {
            type: STRING,
            allowNull: false,
        },
        phone_type: {
            type: STRING,
            allowNull: true,
            defaultValue: '',
        },
        app_version: {
            type: STRING,
            allowNull: true,
            defaultValue: '',
        },
        tags: {
            type: STRING,
            allowNull: true,
            defaultValue: '',
        },
        product_id: {
            type: INTEGER,
            allowNull: true,
            defaultValue: 1,
        },
        is_deleted: {
            type: INTEGER,
            allowNull: false,
            defaultValue: 0,
        },
        created_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            tableName: 'sys_user_app_feedback',
            timestamps: false,
            freezeTableName: true
        });

    UserAppFeedback.get = async function (id, options = {}) {

        const default_options = { where: {}, orders: [] };//to add other condition
        options.where = options.where ? Object.assign(default_options.where, options.where) : default_options.where;
        options = Object.assign(default_options, options);
        options.order = this.formatOrders(options.orders);
        delete options.orders;

        return await this.findByPk(id, options);
    }

    UserAppFeedback.getOne = async function (options) {

        const default_options = { where: {}, orders: [] };//to add other condition
        options.where = options.where ? Object.assign(default_options.where, options.where) : default_options.where;
        options = Object.assign(default_options, options);
        options.order = this.formatOrders(options.orders);
        delete options.orders;

        return await this.findOne(options);
    };

    UserAppFeedback.getAll = async function (options) {

        const default_options = { where: { is_deleted: 0 }, orders: [{ id: 'desc' }] };//to add other condition
        options.where = options.where ? Object.assign(default_options.where, options.where) : default_options.where;
        options = Object.assign(default_options, options);
        options.order = this.formatOrders(options.orders);
        delete options.orders;

        return await this.findAll(options);

    };

    UserAppFeedback.getList = async function (options) {

        const default_options = { limit: 10, page: 1, where: { is_deleted: 0 }, orders: [{ id: 'desc' }] };//to add other condition
        options.where = options.where ? Object.assign(default_options.where, options.where) : default_options.where;
        options = Object.assign(default_options, options);
        options.offset = (options.page - 1) * options.limit;
        options.order = this.formatOrders(options.orders);
        delete options.orders;

        return await this.findAndCountAll(options);
    };

    UserAppFeedback.updateData = async function (data, options) {

        const default_options = { where: {} };//to add other condition
        options.where = options.where ? Object.assign(default_options.where, options.where) : default_options.where;
        options = Object.assign(default_options, options);

        return await this.update(data, options);
    };

    UserAppFeedback.add = async function (data) {
        return await this.create(data);
    };

    UserAppFeedback.formatOrders = function (data) {
        const orders = [];
        if (data && Array.isArray(data)) {
            for (let i in data) {
                let item = data[i];
                const sorts = Object.keys(item);
                if (!sorts[0]) continue;
                const sort = sorts[0];
                const order = item[sort];
                orders.push([sort, order]);
            }
        }

        return orders
    };

    return UserAppFeedback;
};