
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT } = app.Sequelize;

    const NewHouseType = app.realestateModel.define('new_house_type', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        new_house_id: {
            type: INTEGER,
            allowNull: false
        },
        type: {
            type: INTEGER,
            allowNull: true
        },
        image: {
            type: STRING,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        apartment: {
            type: STRING,
            allowNull: true
        },
        sale_type: {
            type: INTEGER,
            allowNull: true
        },
        area: {
            type: DECIMAL,
            allowNull: true
        },
        orientation: {
            type: STRING,
            allowNull: true
        },
        num: {
            type: INTEGER,
            allowNull: true
        },
        price: {
            type: INTEGER,
            allowNull: true
        },
        discount: {
            type: DECIMAL,
            allowNull: true
        },
        state: {
            type: INTEGER,
            allowNull: true
        },
        remark: {
            type: STRING,
            allowNull: true
        },
        deleted_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'new_house_type',
        });
    return NewHouseType;

};