'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, DATE } = app.Sequelize;
    const HouseImage = app.realestateModel.define('house_image', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        path: STRING,
        connect_id: INTEGER,
        type: INTEGER,
        remark: STRING,
        status: ENUM('online', 'offline'),
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'house_image',
        });

    HouseImage.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseImage.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HouseImage.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseImage.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HouseImage.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await HouseImage.findAndCountAll(condition);
        return { page, count, rows };
    }

    HouseImage.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HouseImage.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HouseImage.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HouseImage.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HouseImage;

};
