
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT } = app.Sequelize;

    const NewHouse = app.realestateModel.define('new_house', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        name: {
            type: STRING,
            allowNull: false
        },
        residential_id: {
            type: INTEGER,
            allowNull: true
        },
        address: {
            type: STRING,
            allowNull: true
        },
        sale_address: {
            type: INTEGER,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        sale_type: {
            type: INTEGER,
            allowNull: true
        },
        house_type: {
            type: INTEGER,
            allowNull: true
        },
        reference_avg_price: {
            type: STRING,
            allowNull: true
        },
        reference_total_price: {
            type: STRING,
            allowNull: true
        },
        image: {
            type: STRING,
            allowNull: true
        },
        discount: {
            type: DECIMAL,
            allowNull: true
        },
        favourable_info: {
            type: STRING,
            allowNull: true
        },
        decoration_type: {
            type: INTEGER,
            allowNull: true
        },
        description: {
            type: TEXT,
            allowNull: true
        },
        open_date: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('open_date');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        due_date: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('due_date');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        land_area: {
            type: DECIMAL,
            allowNull: true
        },
        house_area: {
            type: DECIMAL,
            allowNull: true
        },
        area_ratio: {
            type: DECIMAL,
            allowNull: true
        },
        green_ratio: {
            type: DECIMAL,
            allowNull: true
        },
        plan_rooms: {
            type: INTEGER,
            allowNull: true
        },
        plan_parks: {
            type: INTEGER,
            allowNull: true
        },
        plan_near_by: {
            type: TEXT,
            allowNull: true
        },
        pre_sale_permit: {
            type: STRING,
            allowNull: true
        },
        pre_sale_permit_date: {
            type: STRING,
            allowNull: true
        },
        building_numbers: {
            type: STRING,
            allowNull: true
        },
        order_num: {
            type: INTEGER,
            allowNull: true
        },
        state: {
            type: INTEGER,
            allowNull: true
        },
        remark: {
            type: INTEGER,
            allowNull: true
        },
        deleted_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'new_house',
        });
    return NewHouse;

};