'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM } = app.Sequelize;
  const RecommendChannelProduct = app.blockModel.define('recommend_channel_product', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    option_id: STRING,
    product_id: STRING,
    identifier: STRING,
    type: ENUM('normal', 'quality'),
    order: INTEGER,
    status: ENUM('offline', 'online'),
    valid: INTEGER,
    // 注意，需要转成string
    created_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'recommend_channel_product',
  });

  RecommendChannelProduct.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await RecommendChannelProduct.findOne({
      attributes,
      where,
    });
  };


  RecommendChannelProduct.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await RecommendChannelProduct.findAll({
      attributes,
      where,
    });
  };

  RecommendChannelProduct.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await RecommendChannelProduct.findAndCountAll(condition);
    return { page, count, rows };
  };

  RecommendChannelProduct.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await RecommendChannelProduct.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      ctx.status = 500;
      throw (error);
    }
  };

  RecommendChannelProduct.edit = async data => {
    const where = data.where;
    const params = data.params;
    RecommendChannelProduct.update(params, {
      where,
    }).catch(e => res.json({ status: 500, error: e }));
  };

  return RecommendChannelProduct;

};
