'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, DATE } = app.Sequelize;
    const SearchHistory = app.realestateModel.define('search_history', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        user_id: {
            type: STRING,
            allowNull: true
        },
        app_user_id: {
            type: STRING,
            allowNull: true
        },
        key_word: {
            type: STRING,
            allowNull: true
        },
        house_style: {
            type: INTEGER,
            allowNull: true
        },
        state: {
            type: INTEGER,
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'search_history',
        });

    SearchHistory.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await SearchHistory.findOne({
            attributes: attributes,
            where: where,
        });
    }


    SearchHistory.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await SearchHistory.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    SearchHistory.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await SearchHistory.findAndCountAll(condition);
        return { page, count, rows };
    }

    SearchHistory.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await SearchHistory.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    SearchHistory.edit = async (data) => {

        const where = data.where;
        const params = data.params;
        try {
            return res = await SearchHistory.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return SearchHistory;

};
