'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER} = app.Sequelize;
  const MessageType = app.huodongModel.define('cfg_messages_type', {
    id: { type: STRING, primaryKey: true },
    name: STRING,
    icon: STRING,
    description: STRING,
    app_id: STRING,
    app_type_id: STRING,
    validate: INTEGER,
    is_system: INTEGER,
  }, {
    timestamps: false,
    tableName: 'cfg_messages_type',
  });

  MessageType.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
      return await MessageType.findOne({
          attributes: attributes,
          where : where,
      });
  }


  MessageType.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await MessageType.findAll({
        attributes: attributes,
        where : where,
    });
  }

  MessageType.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } =  await MessageType.findAndCountAll(condition);
    return { page, count, rows };
  }

  MessageType.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await MessageType.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  MessageType.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    MessageType.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return MessageType;

};
