'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/credit');

    router.get('third', '/home', 'credit.order.getMyCredit');
    router.get('third', '/history/:type', 'credit.order.getRecord');

    //我的信用-黑名单报告
    router.get('third', '/blacklist/report/:report_id', 'credit.blacklist.getBlacklistReport');//获取报告信息
    router.post('third', '/blacklist/report', 'credit.blacklist.applyBlacklistReport');//查询个人黑名单报告
    router.post('third', '/blacklist/verification_code', 'credit.blacklist.getBlacklistReportVerificationCode');//获取短信验证码


    //我的信用-个人通话风险
    router.get('/callrisk/report/:report_id', 'credit.callrisk.getReport');//获取报告信息
    router.post('/callrisk/query', 'credit.callrisk.queryCallRisk');//查询个人通话信息


};
