
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class ApplyService extends Service {

    /**
     * 获取短信验证码
     * @param {*} inputParams 
     */
    async getVerificationCode(inputParams) {
        const { ctx, app } = this;
        ctx.logger.info(inputParams);
        //姓名手机号和身份证校验
        let idVerify = ctx.helper.verify_id_card(inputParams.id_card);
        let phoneVerify = ctx.helper.isPhoneNumber(inputParams.phone);
        let nameVerify = ctx.helper.verify_real_name(inputParams.name);
        if (!idVerify) {
            ctx.failed('身份证输入有误，请校验后输入');
        }
        if (!phoneVerify) {
            ctx.failed('手机号输入有误，请校验后输入');
        }
        if (nameVerify !== 1) {
            ctx.failed('姓名输入有误，请校验后输入');
        }

        //TODO 三要素校验

        //生成四位验证码
        /**
         * redis保存
         * SET KEY VALUE [EX seconds]|[PX milliseconds] [NX|XX]
         * EX seconds − 设置指定的到期时间(以秒为单位)。
         * PX milliseconds - 设置指定的到期时间(以毫秒为单位)。
         * NX - 仅在键不存在时设置键。
         * XX - 只有在键已存在时才设置。
         */
        //60秒只能获取一次
        let lockKey = 'mine:credit:black:lock' + inputParams.phone;
        let lock = await app.redis.get(lockKey);
        ctx.logger.info(lock);
        if (lock && lock !== null) {
            ctx.failed('获取验证码过于频繁，请稍后再试');
        }
        await app.redis.set(lockKey, 'lock', 'EX', 60);//60秒锁

        //每日次数限制
        let timesKey = 'mine:credit:black:times' + inputParams.phone;
        let times = await app.redis.get(timesKey);
        ctx.logger.info(times);
        if (!times) {
            times = 0;
        }
        times++;
        if (times >= 6) {
            ctx.failed('今日获取验证码次数过多，请明日再试');
        }
        let pexpire = new Date(moment().add(1, 'days').format('YYYY-MM-DD')).getTime();
        await app.redis.set(timesKey, times, 'PX', pexpire);//今日有效

        //生成
        let code = '';
        code = Math.round(Math.random() * 9999).toString();
        let len = code.length;
        if ((4 - len) > 0) {
            for (var i = 0; i < 4 - len; i++) {
                code = '0' + code;
            }
        }
        let codeKey = 'mine:credit:black:code' + inputParams.phone;
        await app.redis.set(codeKey, code, 'EX', 60 * 5);//5分钟有效时间

        let ret = {
            code: 1,
            msg: '短信发送成功'
        }
        let smsParams = {
            phone: inputParams.phone,
            content: '【51公积金】您本次操作的短信验证码为' + code + '，5分钟内有效。谨慎保管，切勿告诉他人。'
        }
        ctx.logger.info(smsParams);
        // let smsResult = await ctx.service.common.sms.sendSms(smsParams);
        // ret.code = smsResult.status === 201 ? 1 : 0;
        // ret.msg = smsResult.status === 201 ? '短信发送成功' : '短信发送失败';
        return ret;
    }


    /**
     * 从数据接口获取用户的黑名单报告信息
     * @param {*} inputParams 
     */
    async applyBlacklist(inputParams) {
        const { ctx, app } = this;
        //验证码校验
        let codeKey = 'mine:credit:black:code' + inputParams.phone;
        let code = await app.redis.get(codeKey);
        if (code !== inputParams.code) {
            ctx.failed('验证码错误，请重试');
        }

        let params = {
            sign: "",
            signParams: {
                appKey: this.config.BLACKLIST_APPLY_APPKEY,
                timestamp: String(new Date().getTime()),
            },
            phone: inputParams.phone,
            name: inputParams.name,
            idcard: inputParams.id_card
        }
        params.sign = await ctx.service.credit.common.sign(params.signParams, this.config.BLACKLIST_APPLY_APPSECRET);
        ctx.logger.info(params);
        let url = this.config.BLACKLIST_APPLY_URL;
        let result = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info(result);
        ctx.logger.info(result.data);
        ctx.logger.info(result.data.data.blackList);

        if (result.status != 200) {
            ctx.failed('数据获取接口异常');
        }
        let applyData = {
            type: 1,
            user_id: ctx.userId,
            app_user_id: ctx.appUserId,
            app_id: ctx.appId,
            app_type_id: ctx.appTypeId,
            name: inputParams.name,
            phone: inputParams.dataphone,
            id_card: inputParams.id_card,
            timestamp: params.signParams.timestamp,
            appkey: this.config.BLACKLIST_APPLY_APPKEY,
            sign: params.sign,
            r_code: result.data.code,
            r_msg: result.data.msg,
            r_order_id: result.data.data.order_id,
        }
        let applyId = await ctx.prometheusModel.CreditApply.create(applyData);
        if (result.data.code === 0) {
            let blacklistInfo = result.data.data.blackList;
            let reportData = {
                name: inputParams.name,
                id_card: inputParams.id_card,
                phone: inputParams.phone,
                age: '',
                city: '',
                blacklist_of_internet_loans: blacklistInfo.pre_loan_risk.blacklist_of_internet_loans,
                blacklist_of_court_dishonesty: blacklistInfo.pre_loan_risk.blacklist_of_court_dishonesty,
                blacklist_of_industry: blacklistInfo.pre_loan_risk.blacklist_of_industry,
                blacklist_of_ds_industry: blacklistInfo.pre_loan_risk.blacklist_of_ds_industry,
                blacklist_of_bx_industry: blacklistInfo.pre_loan_risk.blacklist_of_bx_industry,
                blacklist_of_zc_industry: blacklistInfo.pre_loan_risk.blacklist_of_zc_industry,
                blacklist_of_zf_industry: blacklistInfo.pre_loan_risk.blacklist_of_zf_industry,
                blacklist_of_jd_industry: blacklistInfo.pre_loan_risk.blacklist_of_jd_industry,
                reg_count_1month: blacklistInfo.long_lending_risk.reg_count_1month,
                reg_count_3month: blacklistInfo.long_lending_risk.reg_count_3month,
                reg_count_6month: blacklistInfo.long_lending_risk.reg_count_6month,
                consume_reg_count_1month: blacklistInfo.long_lending_risk.consume_reg_count_1month,
                consume_reg_count_3month: blacklistInfo.long_lending_risk.consume_reg_count_3month,
                consume_reg_count_6month: blacklistInfo.long_lending_risk.consume_reg_count_6month,
                loan_reg_count_1month: blacklistInfo.long_lending_risk.loan_reg_count_1month,
                loan_reg_count_3month: blacklistInfo.long_lending_risk.loan_reg_count_3month,
                loan_reg_count_6month: blacklistInfo.long_lending_risk.loan_reg_count_6month,
                consume_reg_platform_count_1month: blacklistInfo.long_lending_risk.consume_reg_platform_count_1month,
                consume_reg_platform_count_3month: blacklistInfo.long_lending_risk.consume_reg_platform_count_3month,
                consume_reg_platform_count_6month: blacklistInfo.long_lending_risk.consume_reg_platform_count_6month,
                loan_reg_platform_count_1month: blacklistInfo.long_lending_risk.loan_reg_platform_count_1month,
                loan_reg_platform_count_3month: blacklistInfo.long_lending_risk.loan_reg_platform_count_3month,
                loan_reg_platform_count_6month: blacklistInfo.long_lending_risk.loan_reg_platform_count_6month,
                reg_platform_count_1month: blacklistInfo.long_lending_risk.reg_platform_count_1month,
                reg_platform_count_3month: blacklistInfo.long_lending_risk.reg_platform_count_3month,
                reg_platform_count_6month: blacklistInfo.long_lending_risk.reg_platform_count_6month,
                credit_count_1month: blacklistInfo.long_lending_risk.credit_count_1month,
                credit_count_3month: blacklistInfo.long_lending_risk.credit_count_3month,
                credit_count_6month: blacklistInfo.long_lending_risk.credit_count_6month,
                credit_amount_1month: blacklistInfo.long_lending_risk.credit_amount_1month,
                credit_amount_3month: blacklistInfo.long_lending_risk.credit_amount_3month,
                credit_amount_6month: blacklistInfo.long_lending_risk.credit_amount_6month,
                credit_closed_count_1month: blacklistInfo.long_lending_risk.credit_closed_count_1month,
                credit_closed_count_3month: blacklistInfo.long_lending_risk.credit_closed_count_3month,
                credit_closed_count_6month: blacklistInfo.long_lending_risk.credit_closed_count_6month,
                credit_closed_amount_1month: blacklistInfo.long_lending_risk.credit_closed_amount_1month,
                credit_closed_amount_3month: blacklistInfo.long_lending_risk.credit_closed_amount_3month,
                credit_closed_amount_6month: blacklistInfo.long_lending_risk.credit_closed_amount_6month,
                consume_credit_count_1month: blacklistInfo.long_lending_risk.consume_credit_count_1month,
                consume_credit_count_3month: blacklistInfo.long_lending_risk.consume_credit_count_3month,
                consume_credit_count_6month: blacklistInfo.long_lending_risk.consume_credit_count_6month,
                loan_credit_count_1month: blacklistInfo.long_lending_risk.loan_credit_count_1month,
                loan_credit_count_3month: blacklistInfo.long_lending_risk.loan_credit_count_3month,
                loan_credit_count_6month: blacklistInfo.long_lending_risk.loan_credit_count_6month,
                consume_credit_platform_count_1month: blacklistInfo.long_lending_risk.consume_credit_platform_count_1month,
                consume_credit_platform_count_3month: blacklistInfo.long_lending_risk.consume_credit_platform_count_3month,
                consume_credit_platform_count_6month: blacklistInfo.long_lending_risk.consume_credit_platform_count_6month,
                loan_credit_platform_count_1month: blacklistInfo.long_lending_risk.loan_credit_platform_count_1month,
                loan_credit_platform_count_3month: blacklistInfo.long_lending_risk.loan_credit_platform_count_3month,
                loan_credit_platform_count_6month: blacklistInfo.long_lending_risk.loan_credit_platform_count_6month,
                credit_platform_count_1month: blacklistInfo.long_lending_risk.credit_platform_count_1month,
                credit_platform_count_3month: blacklistInfo.long_lending_risk.credit_platform_count_3month,
                credit_platform_count_6month: blacklistInfo.long_lending_risk.credit_platform_count_6month,
                id_card_relevant_mobilephone_count: blacklistInfo.identity_related_risk.id_card_relevant_mobilephone_count,
                id_card_relevant_device_count: blacklistInfo.identity_related_risk.id_card_relevant_device_count,
                mobilephone_relevant_id_card_count: blacklistInfo.identity_related_risk.mobilephone_relevant_id_card_count,
                relevant_loan_app_count_6month: blacklistInfo.related_app.relevant_loan_app_count_6month,
                relevant_gamble_app_count_6month: blacklistInfo.related_app.relevant_gamble_app_count_6month,
                relevant_ip_app_count_6month: blacklistInfo.related_app.relevant_ip_app_count_6month,
                relevant_other_app_count_6month: blacklistInfo.related_app.relevant_other_app_count_6month,
                overdue: JSON.stringify(blacklistInfo.overdue_analysis)
            }
            let reportId = await ctx.prometheusModel.CreditBlacklistReport.create(reportData);
        }
        return true;


    }



}

module.exports = ApplyService;
