
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CreditCallriskCallBehavior = app.prometheusModel.define('credit_callrisk_call_behavior', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        report_id: {
            type: INTEGER,
            allowNull: false,
        },
        active_call_count: {
            type: INTEGER,
            allowNull: true,
        },
        passive_call_count: {
            type: INTEGER,
            allowNull: true,
        },
        each_call_count: {
            type: INTEGER,
            allowNull: true,
        },
        silence_count_3day: {
            type: INTEGER,
            allowNull: false,
        },
        silence_time_3day: {
            type: INTEGER,
            allowNull: false,
        },
        silence_time_rate_3day: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_active_call_count: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_active_call_number: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_active_call_city: {
            type: STRING,
            allowNull: true,
        },
        maximum_passive_call_count: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_passive_call_number: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_passive_call_city: {
            type: STRING,
            allowNull: true,
        },
        maximum_call_time: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_call_time_number: {
            type: INTEGER,
            allowNull: false,
        },
        maximum_call_time_city: {
            type: STRING,
            allowNull: true,
        },
        // is_deleted: {
        //     type: INTEGER,
        //     allowNull: false,
        // },
        // updated_at: {
        //     type: DATE,
        //     allowNull: true,
        //     get() {
        //         const date = this.getDataValue('updated_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // },
        // created_at: {
        //     type: DATE,
        //     allowNull: false,
        //     get() {
        //         const date = this.getDataValue('created_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // }
    }, {
            timestamps: false,
            tableName: 'credit_callrisk_call_behavior',
        });

    CreditCallriskCallBehavior.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditCallriskCallBehavior.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditCallriskCallBehavior.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditCallriskCallBehavior.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditCallriskCallBehavior.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditCallriskCallBehavior.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditCallriskCallBehavior.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditCallriskCallBehavior.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditCallriskCallBehavior.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditCallriskCallBehavior.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditCallriskCallBehavior;

};