'use strict';

const Service = require('egg').Service;

class FootPrintService extends Service {

    async one(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/' + id, {}, { method: 'GET' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async edit(id, data) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/' + id, data, { method: 'PUT' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async delete(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/' + id, {}, { method: 'DELETE' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async all(data) {
        const { ctx } = this;
        const queryConditions = data.queryConditions;
        const sum = queryConditions.length;
        for (let i = 0; i < sum; i++) {
            if (queryConditions[i].key === 'userId' && queryConditions[i].value.length === 0) {
                queryConditions[i].value = true;
                queryConditions[i].operator = 'isnull';
            }
        }
        data.queryConditions = queryConditions;
        if (Object.keys(data.orderConditions).length === 0) {
            data.orderConditions = [{
                key: 'createdAt',
                orderSequence: 'desc',
            }];
        }

        ctx.logger.info('footprint_list_params: ' + JSON.stringify(data));
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/list', data, { method: 'POST' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async add(data) {
        const { ctx } = this;
        ctx.logger.info('add_footprint_params: ' + JSON.stringify(data));
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/footprint/', data, { method: 'POST' });
        ctx.logger.info('add_footprint_results: ' + JSON.stringify(result));
        if (result.status !== 201) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

}

module.exports = FootPrintService;
