'use strict';

const USER_SID = Symbol('Context#user_sid');
const TOKEN = Symbol('Context#token');
const FROM = Symbol('Context#from');

const APPUSERID = Symbol('Context#userUserId');
const DEVICEID = Symbol('Context#deviceId');
const DEVICELOGINID = Symbol('Context#deviceLoginId');
const APPID = Symbol('Context#appId');
const APPTYPEID = Symbol('Context#appTypeId');
const OLDUSERID = Symbol('Context#oldUserId');
const USERID = Symbol('Context#userId');
const OLDCOOKIE = Symbol('Context#oldCookie');
const USERUUID = Symbol('Context#userUuid');

module.exports = {
  failed(message) {
    const method = this.request.method.toLowerCase();
    if (method === 'post') {
      this.throw(422, message);
    } else {
      this.throw(400, message);
    }
  },
  success(data = false) {
    const method = this.request.method.toLowerCase();
    if (method === 'get') {
      this.status = 200;
      this.body = data || {};
    } else if (method === 'post') {
      this.status = 201;
      this.body = data || {};
    } else if (method === 'put' || method === 'delete') {
      this.status = data ? 200 : 204;
      this.body = data ? data : '';
    } else {
      this.status = 204;
      this.body = '';
    }
  },

  isEmpty(data) {
    const type = typeof (data);
    let ret = false;
    switch (type) {
      case 'undefined':
        ret = true;
        break;
      case 'string':
        ret = !(data.length > 0);
        break;
      case 'number':
        ret = !(data > 0);
        break;
      case 'boolean':
        ret = false;
        break;
      case 'object':
        // 判断是否为数组
        if (data instanceof Array) {
          ret = !(data.length > 0);
        } else {
          ret = JSON.stringify(data) === '{}' || !data;
        }
        break;
      default:
        break;
    }
    return ret;
  },

  login(params) {
    const { cookies, session } = this;
    const moment = require('moment');
    const date = new Date();

    params = params || [];

    this[FROM] = 'unknown';
    if (cookies.get('jianbing_customer_id', { signed: false }) && cookies.get('auth_token', { signed: false })) {
      this[FROM] = 'app';
    } else if (session.user_sid && session.token) {
      this[FROM] = 'session';
    }

    switch (this[FROM]) {
      case 'app':
        const user_sid = cookies.get('jianbing_customer_id', { signed: false });
        let auth_token = cookies.get('auth_token', { signed: false });
        const auth_calc = this.helper.md5(String(user_sid) + moment(date).format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
        if (auth_token != auth_calc) {
          const y_auth_calc = this.helper.md5(String(user_sid) + moment(new Date(date.getTime() - 86400000)).format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
          if (auth_token != y_auth_calc) {
            this.throw(403, 'login failed app ' + String(user_sid));
          }
          auth_token = auth_calc;
          cookies.set('auth_token', auth_token, {
            httpOnly: false,
            signed: false,
            maxAge: 7200 * 1000,
          });
        }

        this[USER_SID] = user_sid;
        this[TOKEN] = auth_token;
        session.user_sid = user_sid;
        session.token = auth_token;
        session.from = this[FROM];
        break;
      case 'session':
        this[USER_SID] = session.user_sid;
        this[TOKEN] = session.token;
        this[FROM] = session.from;
        break;
      default:
        break;
    }
  },

  // 注意，symbol && getter, 必须有get函数
  get user_sid() {
    this.login();
    return this[USER_SID];
    const token = this.request.header.authorization;
    if (!token) {
      return '';
    }
    const decode_ret = this.app.jwt.decode(token.replace('Bearer ', ''), this.app.config.jwt.secret);
    this.helper.debug(decode_ret.data);
    return decode_ret.data.user_sid;
    // return this[USER_SID];
  },

  get token() {
    return this[TOKEN];
  },

  get from() {
    return this[FROM];
  },

  // 注意，symbol && getter, 必须有get函数
  get appUserId() {
    return this[APPUSERID];
  },

  get deviceId() {
    return this[DEVICEID];
  },

  get deviceLoginId() {
    return this[DEVICELOGINID];
  },

  get appId() {
    return this[APPID];
  },

  get appTypeId() {
    return this[APPTYPEID];
  },

  get oldUserId() {
    return this[OLDUSERID];
  },

  get userId() {
    return this[USERID];
  },

  get oldCookie() {
    return this[OLDCOOKIE];
  },

  get userUuid() {
    return this[USERUUID];
  },

  setAppUserId(app_user_id) {
    this[APPUSERID] = app_user_id;
  },

  setDeviceId(device_id) {
    this[DEVICEID] = device_id;
  },

  setDeviceLoginId(device_login_id) {
    this[DEVICELOGINID] = device_login_id;
  },

  setAppId(app_id) {
    this[APPID] = app_id;
  },

  setAppTypeId(app_type_id) {
    this[APPTYPEID] = app_type_id;
  },

  setOldUserId(old_user_id) {
    this[OLDUSERID] = old_user_id;
  },

  setUserId(uid) {
    this[USERID] = uid;
  },

  setOldCookie(cookie) {
    this[OLDCOOKIE] = cookie;
  },

  setUserUuid(user_uuid) {
    this[USERUUID] = user_uuid;
  },
};
