
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CreditPay = app.prometheusModel.define('credit_pay', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        order_id: {
            type: INTEGER,
            allowNull: false,
        },
        trade_no: {
            type: STRING,
            allowNull: false,
        },
        prepay_id: {
            type: STRING,
            allowNull: false,
        },
        transaction_id: {
            type: STRING,
            allowNull: true,
        },
        amount: {
            type: DECIMAL,
            allowNull: false,
        },
        description: {
            type: STRING,
            allowNull: true,
        },
        client_ip: {
            type: STRING,
            allowNull: true,
        },
        unifiedorder_result: {
            type: STRING,
            allowNull: false,
        },
        pay_result: {
            type: STRING,
            allowNull: true,
        },
        status: {
            type: INTEGER,
            allowNull: true,
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'credit_pay',
        });

    CreditPay.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditPay.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditPay.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditPay.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditPay.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditPay.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditPay.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditPay.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditPay.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditPay.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditPay;

};